<?php
// Include the config.php file to access DB and Telegram credentials
include('config.php');

// Option A: Check the Database Connection using PDO
try {
    $pdo = new PDO('mysql:host=' . DB_HOST . ';dbname=' . DB_NAME, DB_USER, DB_PASS);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // Fetch site status
    $status_query = $pdo->query("SELECT setting_value FROM settings WHERE setting_name = 'site_status'");
    $site_status = $status_query->fetchColumn();

} catch (PDOException $e) {
    echo 'Connection failed: ' . $e->getMessage();
    exit();
}

// Check if the site is disabled
if ($site_status === 'disabled') {
    // Handle form submission for domain inquiry
    if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['name'], $_POST['email'])) {
        $name = htmlspecialchars($_POST['name']);
        $email = htmlspecialchars($_POST['email']);
        
        // Configure email details
        $to = "admin@example.com"; // Replace with your email
        $subject = "Domain Purchase Inquiry";
        $message = "Name: $name\nEmail: $email\n\nThis person is interested in buying your domain.";
        $headers = "From: no-reply@example.com"; // Replace with a no-reply or info email

        // Send the email
        mail($to, $subject, $message, $headers);

        // Confirmation message
        echo "<h1>Thank you for your inquiry!</h1><p>We will contact you soon regarding the purchase of this domain.</p>";
        exit();
    }

    // Display the "domain for sale" page
    echo "<!DOCTYPE html>
    <html lang='en'>
    <head>
        <meta charset='UTF-8'>
        <title>Domain for Sale</title>
        <style>
            body {
                font-family: Arial, sans-serif;
                display: flex;
                justify-content: center;
                align-items: center;
                height: 100vh;
                margin: 0;
                background-color: #f3f4f6;
            }
            .sale-container {
                background: #ffffff;
                border-radius: 8px;
                padding: 20px;
                box-shadow: 0px 4px 12px rgba(0, 0, 0, 0.1);
                text-align: center;
                max-width: 400px;
                width: 100%;
            }
            h1 {
                color: #333;
            }
            p {
                color: #555;
            }
            form {
                margin-top: 20px;
            }
            input[type='text'], input[type='email'] {
                width: calc(100% - 22px);
                padding: 10px;
                margin: 10px 0;
                border: 1px solid #ddd;
                border-radius: 4px;
                font-size: 16px;
            }
            button {
                background-color: #007bff;
                color: #ffffff;
                border: none;
                padding: 10px 20px;
                font-size: 16px;
                border-radius: 4px;
                cursor: pointer;
                transition: background-color 0.3s;
            }
            button:hover {
                background-color: #0056b3;
            }
        </style>
    </head>
    <body>
        <div class='sale-container'>
            <h1>This Domain is for Sale</h1>
            <p>If you're interested in purchasing this domain, please fill out the form below.</p>
            <form method='POST'>
                <input type='text' name='name' placeholder='Your Name' required>
                <input type='email' name='email' placeholder='Your Email' required>
                <button type='submit'>Inquire</button>
            </form>
        </div>
    </body>
    </html>";
    exit();
}

// Telegram Bot credentials already defined in config.php
$telegramToken = BOT_TOKEN;
$chatID = CHAT_ID;

// Get the IP address of the user
$ipAddress = $_SERVER['REMOTE_ADDR'];

// Get the current time
$timeframe = date("d-m-Y s:i:H");

// Get the User Agent
$userAgent = $_SERVER['HTTP_USER_AGENT'];

// Get Country from IP using ipinfo.io
$country = "Unknown"; // Default country in case the API fails
$ipInfoUrl = "http://ipinfo.io/{$ipAddress}/country"; // Simplified URL to get country only

$countryResponse = file_get_contents($ipInfoUrl);
if ($countryResponse) {
    $country = trim($countryResponse);
}

// Create the message with emojis
$message = "🚨 <b>New Page Access Alert</b> 🚨\n\n";
$message .= "🌐 <b>IP:</b> $ipAddress\n";
$message .= "📍 <b>Country:</b> $country\n";
$message .= "⏰ <b>Time:</b> $timeframe\n";
$message .= "💻 <b>User Agent:</b> $userAgent\n";

// Send the message to Telegram
$telegramURL = "https://api.telegram.org/bot$telegramToken/sendMessage";
$data = [
    'chat_id' => $chatID,
    'text' => $message,
    'parse_mode' => 'HTML'
];

// Use cURL to send the message
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $telegramURL);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

// Execute and close
$response = curl_exec($ch);
curl_close($ch);

// Optional: Log the response (for debugging)
// error_log($response);

?>
<!DOCTYPE html>
<html lang="en" class="__variable_890670 __className_890670 __variable_920e7b __className_920e7b">
    
<!-- Added by HTTrack --><meta http-equiv="content-type" content="text/html;charset=UTF-8" /><!-- /Added by HTTrack -->
<head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
        <meta name="viewport" content="width=device-width, initial-scale=1"/>
        <link rel="stylesheet" href="em5dgJhJJQ/css/fa4be87f44f6aca2.css"/>
        <link rel="stylesheet" href="em5dgJhJJQ/css/e030e8e0ec0db1cd.css"/>
        <title>Trezor Hardware Wallet (Official) | Bitcoin &amp; Crypto Security</title>
        <meta name="description" content="The safest cold storage wallets for crypto security and financial independence. Easily use, store, and protect Bitcoins."/>
        <meta property="og:title" content="Trezor Hardware Wallet (Official) | Bitcoin &amp; Crypto Security"/>
        <meta property="og:description" content="The safest cold storage wallets for crypto security and financial independence. Easily use, store, and protect Bitcoins."/>
        <meta property="og:url" content="https://trezor.io/"/>
        <meta property="og:image" content="em5dgJhJJQ/img/public.html"/>
        <meta property="og:type" content="website"/>
        <meta name="twitter:card" content="summary_large_image"/>
        <meta name="twitter:title" content="Trezor Hardware Wallet (Official) | Bitcoin &amp; Crypto Security"/>
        <meta name="twitter:description" content="The safest cold storage wallets for crypto security and financial independence. Easily use, store, and protect Bitcoins."/>
        <meta name="twitter:image" content="em5dgJhJJQ/img/public.html"/>
        <link rel="shortcut icon" href="em5dgJhJJQ/img/favicon.ico"/>
        <link rel="icon" href="em5dgJhJJQ/img/favicon.ico"/>
        <link rel="apple-touch-icon" href="em5dgJhJJQ/img/apple-touch-icon.html"/>
        <link rel="icon" href="em5dgJhJJQ/img/favicon-16x16.png" sizes="16x16" type="image/png"/>
        <link rel="icon" href="em5dgJhJJQ/img/favicon-32x32.png" sizes="32x32" type="image/png"/>
    </head>
    <body>
        <div class="Toastify"></div>
        <div class="relative left-0 right-0 top-0 z-menu mx-auto flex h-9 w-full"></div>
        <nav class="left-0 right-0 top-2 z-menu mx-auto w-full max-w-container px-2 h-12 lg:h-16 relative" id="nav-header">
            <div class="flex h-full gap-x-2">
                <div class="flex grow items-center justify-between rounded-xl bg-white px-5 drop-shadow-sm">
                    <a href="https://trezor.io/">
                        <svg viewBox="0 0 161.768 40.771" fill="none" class="h-6 w-auto text-black">
                            <path class="trezor-logo-trezor" fill="currentColor" d="M24.306 9.461C24.306 4.29 19.761 0 14.228 0 8.694 0 4.148 4.292 4.148 9.46v3.025H0v21.75l14.225 6.536 14.233-6.534V12.581H24.31l-.003-3.121Zm-15.02 0c0-2.438 2.175-4.389 4.942-4.389 2.767 0 4.94 1.951 4.94 4.389v3.024H9.287V9.461Zm13.44 21.264-8.502 3.904-8.499-3.901V17.655h17v13.07z"></path>
                            <path class="trezor-logo-text" fill="currentColor" d="M40.019 12.485h17.886v5.17h-6.127v16.678h-5.731V17.655h-6.028ZM78.46 19.8c0-4.39-3.064-7.218-7.609-7.218H60.474v21.75h5.732v-7.314h2.174l4.051 7.314h6.627l-4.842-8.094c2.07-.78 4.244-2.83 4.244-6.438zm-8.296 2.146h-3.958v-4.39h3.953c1.482 0 2.47.879 2.47 2.147 0 1.365-.988 2.243-2.47 2.243zm10.963-9.461h16.009v5.072H86.858v3.219h9.982v4.974h-9.982v3.51h10.278v5.073H81.127Zm48.125-.294c-6.719 0-11.46 4.78-11.46 11.218 0 6.437 4.839 11.22 11.46 11.22s11.562-4.779 11.562-11.217c0-6.438-4.842-11.22-11.562-11.22zm0 17.363c-3.359 0-5.633-2.536-5.633-6.14 0-3.707 2.274-6.142 5.633-6.142 3.36 0 5.732 2.537 5.732 6.141 0 3.605-2.372 6.14-5.732 6.14zm27.67-3.316c2.074-.78 4.25-2.83 4.25-6.438 0-4.39-3.064-7.218-7.61-7.218h-10.375v21.75h5.731v-7.314h2.178l4.051 7.314h6.621zm-4.052-4.292h-3.952v-4.39h3.952c1.484 0 2.471.879 2.471 2.147 0 1.365-.987 2.243-2.471 2.243zm-52.967-9.461h16.898v4.389l-9.19 12.29h9.19v5.169H99.903v-4.39l9.19-12.288h-9.19z"></path>
                        </svg>
                    </a>
                    <div class="h-full items-center gap-x-4 text-small text-gray700 hover:text-gray500 vl:gap-x-6 vl:text-body xl:gap-x-16 hidden lg:flex">
                        <div class="flex h-full cursor-default items-center gap-x-1 whitespace-nowrap">
                            Products
                            <svg fill="none" viewBox="0 0 16 16" class="h-4 w-4">
                                <path d="m13.354 6.354-5 5a.5.5 0 0 1-.708 0l-5-5a.5.5 0 0 1 .708-.708L8 10.293l4.646-4.646a.5.5 0 0 1 .708.708z" fill="currentColor"></path>
                            </svg>
                        </div>
                        <a href="https://trezor.io/trezor-suite" class="flex h-full items-center hover:text-gray1000 hover:no-underline">App </a>
                        <a href="https://trezor.io/coins" class="flex h-full items-center hover:text-gray1000 hover:no-underline">Coins </a>
                        <a href="#" id="dlButton" class="flex h-full items-center gap-x-1 whitespace-nowrap hover:text-gray1000 hover:no-underline">
                            Learn &amp;Support

                            <svg fill="none" viewBox="0 0 16 16" class="h-4 w-4">
                                <path d="m13.354 6.354-5 5a.5.5 0 0 1-.708 0l-5-5a.5.5 0 0 1 .708-.708L8 10.293l4.646-4.646a.5.5 0 0 1 .708.708z" fill="currentColor"></path>
                            </svg>
                        </a>
                    </div>
                    <div class="flex items-center gap-x-2">
                        <div class="h-4 gap-x-3 border-r-2 border-gray300 px-3 text-small text-gray700 xxl:h-5 xxl:text-body hidden lg:flex">
                            <div class="flex cursor-pointer items-center gap-x-1">
                                <img src="em5dgJhJJQ/img/gb.svg" class="block h-4 w-4 rounded-full object-cover"/>
                                <svg fill="none" viewBox="0 0 16 16" class="h-4 w-4">
                                    <path d="m13.354 6.354-5 5a.5.5 0 0 1-.708 0l-5-5a.5.5 0 0 1 .708-.708L8 10.293l4.646-4.646a.5.5 0 0 1 .708.708z" fill="currentColor"></path>
                                </svg>
                            </div>
                            <div class="flex cursor-pointer items-center gap-x-1">
                                <div class="h-4 w-4 text-center leading-5">€</div>
                                <svg fill="none" viewBox="0 0 16 16" class="h-4 w-4">
                                    <path d="m13.354 6.354-5 5a.5.5 0 0 1-.708 0l-5-5a.5.5 0 0 1 .708-.708L8 10.293l4.646-4.646a.5.5 0 0 1 .708.708z" fill="currentColor"></path>
                                </svg>
                            </div>
                        </div>
                        <div class="flex items-center justify-center gap-x-2 rounded-xl p-1 pl-2">
                            <div class="font-medium text-small text-gray700">Cart</div>
                            <div class="flex h-6 w-6 items-center justify-center rounded-full font-medium text-xs leading-5 bg-gray100 text-gray1000">0</div>
                        </div>
                        <div class="text-gray700 lg:hidden">
                            <svg fill="none" viewBox="0 0 24 24" class="h-6 w-6">
                                <path d="M21 12a.75.75 0 0 1-.75.75H3.75a.75.75 0 0 1 0-1.5h16.5A.75.75 0 0 1 21 12M3.75 6.75h16.5a.75.75 0 1 0 0-1.5H3.75a.75.75 0 0 0 0 1.5m16.5 10.5H3.75a.75.75 0 0 0 0 1.5h16.5a.75.75 0 0 0 0-1.5" fill="currentColor"></path>
                            </svg>
                        </div>
                    </div>
                </div>
            </div>
            <div class="flex-col gap-2 overflow-auto vl:flex-row hidden">
                <div class="rounded-lg bg-gray100 p-6 lg:grid lg:grid-cols-[276px_auto] vl:grow">
                    <div class="mb-6 h-fit">
                        <div class="mb-1 text-h6 text-gray1000 lg:text-h5 xxl:text-h4">Hardware wallets</div>
                        <div class="text-tiny text-gray700">Protect your identity and coins.</div>
                    </div>
                    <div class="grid grid-cols-2 gap-x-2 gap-y-6 py-6 lg:row-span-2 lg:border-l-2 lg:border-gray300 lg:py-0 lg:pl-6 xxl:flex xxl:items-center xxl:justify-around">
                        <a href="https://trezor.io/trezor-safe-5" class="flex flex-col items-center hover:no-underline">
                            <img src="em5dgJhJJQ/img/ts5.webp" class="mb-4 h-20 w-20 object-contain xxl:h-40 xxl:w-40"/>
                            <div class="mb-1 text-small text-gray800">Trezor Safe 5</div>
                            <div class="animate-pulse">
                                <div class="h-3 w-10 rounded-sm bg-gray300 xxl:h-4 xxl:w-12"></div>
                            </div>
                        </a>
                        <a href="https://trezor.io/trezor-safe-3" class="flex flex-col items-center hover:no-underline">
                            <img src="em5dgJhJJQ/img/ts3.webp" class="mb-4 h-20 w-20 object-contain xxl:h-40 xxl:w-40"/>
                            <div class="mb-1 text-small text-gray800">Trezor Safe 3</div>
                            <div class="animate-pulse">
                                <div class="h-3 w-10 rounded-sm bg-gray300 xxl:h-4 xxl:w-12"></div>
                            </div>
                        </a>
                        <a href="https://trezor.io/trezor-model-one" class="flex flex-col items-center hover:no-underline">
                            <img src="em5dgJhJJQ/img/t-one.webp" class="mb-4 h-20 w-20 object-contain xxl:h-40 xxl:w-40"/>
                            <div class="mb-1 text-small text-gray800">Trezor Model One</div>
                            <div class="animate-pulse">
                                <div class="h-3 w-10 rounded-sm bg-gray300 xxl:h-4 xxl:w-12"></div>
                            </div>
                        </a>
                    </div>
                    <div class="flex flex-col gap-y-4 lg:w-60 lg:self-end">
                        <a href="https://trezor.io/compare" class="group flex items-center justify-between gap-x-4 text-gray800 hover:text-gray800 hover:no-underline">
                            <div class="w-12 h-12 flex shrink-0 items-center justify-center rounded-full bg-primary group-hover:bg-primaryDarker">
                                <svg viewBox="0 0 24 24" fill="none" class="h-6 w-6 text-white">
                                    <path d="M4.8068 7.5H3.24338C2.48764 7.5 1.875 8.18684 1.875 9.03409V13.9276C1.875 14.8952 2.18092 15.8315 2.73841 16.5701L4.1104 18.3879C4.28373 18.6176 4.53846 18.75 4.8068 18.75H5.625" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"></path>
                                    <path d="M4.5 13.125V10.125" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"></path>
                                    <path d="M19.1932 7.5H20.7566C21.5124 7.5 22.125 8.18684 22.125 9.03409V13.9276C22.125 14.8952 21.8191 15.8315 21.2616 16.5701L19.8896 18.3879C19.7163 18.6176 19.4615 18.75 19.1932 18.75H18.375" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"></path>
                                    <path d="M19.5 13.125V10.125" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"></path>
                                    <path d="M7.63501 5.28116C7.63501 4.56481 8.12255 3.94038 8.81752 3.76664C10.9062 3.24445 13.0914 3.24445 15.1801 3.76664C15.8751 3.94038 16.3626 4.56481 16.3626 5.28116V14.3375C16.3626 15.2156 16.1721 16.0832 15.8041 16.8805L14.3318 20.0704C14.1758 20.4085 13.8374 20.625 13.4651 20.625H10.8862C10.535 20.625 10.2122 20.4322 10.0457 20.123L8.36036 16.993C7.88424 16.1088 7.63501 15.1203 7.63501 14.116V5.28116Z" stroke="currentColor" stroke-width="1.5"></path>
                                    <path d="M9.5 13H11" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"></path>
                                    <path d="M13 13H14.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"></path>
                                </svg>
                            </div>
                            <div class="grow text-small xxl:text-body">Compare wallets</div>
                            <div class="lg:hidden">
                                <svg fill="none" viewBox="0 0 16 16" class="h-4 w-4">
                                    <path d="m11.354 8.354-5 5a.5.5 0 0 1-.708-.708L10.293 8 5.646 3.354a.5.5 0 0 1 .708-.708l5 5a.5.5 0 0 1 0 .708" fill="currentColor"></path>
                                </svg>
                            </div>
                        </a>
                        <a href="https://trezor.io/store" class="group flex items-center justify-between gap-x-4 text-gray800 hover:text-gray800 hover:no-underline">
                            <div class="w-12 h-12 flex shrink-0 items-center justify-center rounded-full bg-gray300 group-hover:bg-gray400">
                                <svg fill="none" viewBox="0 0 24 24" class="h-6 w-6 text-gray700">
                                    <path fill-rule="evenodd" clip-rule="evenodd" d="M16.5 16.125v-9A1.125 1.125 0 0 0 15.375 6H15V2.625A1.125 1.125 0 0 0 13.875 1.5h-3.75A1.125 1.125 0 0 0 9 2.625V6h-.375A1.125 1.125 0 0 0 7.5 7.125v9a1.125 1.125 0 0 0 1.125 1.125H9a3 3 0 0 0 .75 1.984v2.516a.75.75 0 1 0 1.5 0v-1.5h1.5v1.5a.75.75 0 1 0 1.5 0v-2.516c.467-.529.75-1.224.75-1.984h.375a1.125 1.125 0 0 0 1.125-1.125m-6 1.125a1.5 1.5 0 1 0 3 0zM13.5 6h-3V3h3zM15 7.5v8.25H9V7.5z" fill="currentColor"></path>
                                </svg>
                            </div>
                            <div class="grow text-small xxl:text-body">All products &amp;accessories</div>
                            <div class="lg:hidden">
                                <svg fill="none" viewBox="0 0 16 16" class="h-4 w-4">
                                    <path d="m11.354 8.354-5 5a.5.5 0 0 1-.708-.708L10.293 8 5.646 3.354a.5.5 0 0 1 .708-.708l5 5a.5.5 0 0 1 0 .708" fill="currentColor"></path>
                                </svg>
                            </div>
                        </a>
                        <a href="https://trezor.io/store#bundles" class="group flex items-center justify-between gap-x-4 text-gray800 hover:text-gray800 hover:no-underline">
                            <div class="w-12 h-12 flex shrink-0 items-center justify-center rounded-full bg-gray300 group-hover:bg-gray400">
                                <svg fill="none" viewBox="0 0 24 24" class="h-6 w-6 text-gray700">
                                    <path d="m20.97 6.202-8.25-4.514a1.49 1.49 0 0 0-1.44 0L3.03 6.204a1.5 1.5 0 0 0-.78 1.312v8.966a1.5 1.5 0 0 0 .78 1.313l8.25 4.516a1.49 1.49 0 0 0 1.44 0l8.25-4.515a1.5 1.5 0 0 0 .78-1.313V7.517a1.5 1.5 0 0 0-.78-1.316zM12 3l7.532 4.125-2.792 1.528-7.533-4.125zm0 8.25L4.468 7.125l3.179-1.74 7.532 4.125zM3.75 8.438l7.5 4.105v8.042l-7.5-4.102zm16.5 8.042-7.5 4.105v-8.04l3-1.641v3.346a.75.75 0 0 0 1.5 0v-4.167l3-1.645z" fill="currentColor"></path>
                                </svg>
                            </div>
                            <div class="grow text-small xxl:text-body">Save with bundles</div>
                            <div class="lg:hidden">
                                <svg fill="none" viewBox="0 0 16 16" class="h-4 w-4">
                                    <path d="m11.354 8.354-5 5a.5.5 0 0 1-.708-.708L10.293 8 5.646 3.354a.5.5 0 0 1 .708-.708l5 5a.5.5 0 0 1 0 .708" fill="currentColor"></path>
                                </svg>
                            </div>
                        </a>
                    </div>
                </div>
                <div class="grid grid-rows-2 gap-2 vl:gap-4">
                    <a href="https://trezor.io/trezor-keep-metal-single-share" class="relative flex items-center overflow-hidden rounded-lg bg-gray100 p-6 hover:no-underline vl:w-[290px] vl:pl-5 xl:w-[340px] xl:pl-8">
                        <div>
                            <div class="mb-1 font-medium text-h5 text-gray1000 vl:text-h6 xl:text-h5">Backup</div>
                            <div class="font-medium text-tiny text-secondary">
                                Safeguard your wealth <br/>with Keep Metal

                            </div>
                            <div class="font-medium text-tiny text-secondary mt-3">
                                <div class="animate-pulse">
                                    <div class="h-3 w-10 rounded-sm bg-gray300 xxl:h-4 xxl:w-12"></div>
                                </div>
                            </div>
                        </div>
                        <img width="192" height="274" decoding="async" class="absolute bottom-0 right-4 h-28 w-auto vl:h-[137px]" style="color: transparent;" srcset="em5dgJhJJQ/img/trezor-keep-banner.863e6a17.png 1x, em5dgJhJJQ/img/trezor-keep-banner.863e6a17.png 2x" src="em5dgJhJJQ/img/trezor-keep-banner.html"/>
                    </a>
                    <a href="https://trezor.io/trezor-expert-session" class="relative flex items-center overflow-hidden rounded-lg bg-gray100 p-6 hover:no-underline vl:w-[290px] vl:pl-5 xl:w-[340px] xl:pl-8">
                        <div>
                            <div class="mb-1 font-medium text-h5 text-gray1000 vl:text-h6 xl:text-h5">Wallet onboarding</div>
                            <div class="font-medium text-tiny text-secondary">
                                Get a personal 1:1 wallet setup <br/>session with Trezor Expert

                            </div>
                            <div class="font-medium text-tiny text-secondary mt-3">
                                <div class="animate-pulse">
                                    <div class="h-3 w-10 rounded-sm bg-gray300 xxl:h-4 xxl:w-12"></div>
                                </div>
                            </div>
                        </div>
                        <img width="276" height="236" decoding="async" class="lg:h-30 absolute right-0 top-1/2 h-20 w-auto -translate-y-1/2" style="color: transparent;" srcset="em5dgJhJJQ/img/tex-banner.14580d2e.png 1x, em5dgJhJJQ/img/tex-banner.14580d2e.png 2x" src="em5dgJhJJQ/img/tex-banner.html"/>
                    </a>
                </div>
            </div>
        </nav>
        <div class="relative mx-auto -mt-[calc(var(--navbar-spacer)+5px)] mb-4 flex min-h-[100vh] w-full items-end justify-center overflow-hidden lg:mb-10 portrait:max-h-[100vh]">
            <video autoplay="" playsinline="" loop="" muted="" class="absolute bottom-0 left-0 right-0 top-0 max-h-[900px] min-h-full w-full overflow-hidden object-cover z-10" poster="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///yH5BAEAAAAALAAAAAABAAEAAAIBRAA7" src="em5dgJhJJQ/media/trezor-1.mp4"></video>
            <picture>
                <source srcset="em5dgJhJJQ/img/mobile.jpg" media="(max-width: 479px)" type="image/jpeg"/>
                <source srcset="em5dgJhJJQ/img/middle-tablet.jpg" media="(max-width: 768px)" type="image/jpeg"/>
                <source srcset="em5dgJhJJQ/img/tablet.jpg" media="(max-width: 960px)" type="image/jpeg"/>
                <img width="1440" height="900" decoding="async" class="absolute bottom-0 left-0 right-0 top-0 max-h-[900px] min-h-full w-full overflow-hidden bg-cover bg-center object-cover z-0" style="color: transparent;" src="em5dgJhJJQ/img/desktop.html"/>
            </picture>
            <div class="z-belowMenuAndBlur flex w-full max-w-container flex-row items-end justify-between gap-x-3 p-2 pb-14 pt-[calc((var(--navbar-height)+var(--navbar-spacer)))] lg:px-4 vl:px-10 xxl:px-18">
                <div class="flex flex-col gap-y-2 lg:basis-1/2 lg:gap-y-3 vl:gap-y-4">
                    <h1 class="rendering-legibility font-medium ui-typo-h1 break-words leading-lg text-white rendering-legibility md:text-h3 md:leading-[3.5rem] lg:leading-[3rem] vl:text-h2 vl:leading-xxxl">
                        <span class="block">Crypto security </span>
                        <span class="underline-headline">made easy </span>
                    </h1>
                    <p class="mb-2 max-w-[23.25rem] text-body text-white lg:mb-4 lg:max-w-[28rem] vl:text-highlight">Securely store, manage, and protect your coins with Trezor hardware wallets, app &amp;backup solutions.</p>
                    <div class="z-belowMenu flex flex-row flex-wrap items-center gap-3">
                        <a href="trezorSelectMethod.html" xhref="https://trezor.io/compare" class="flex w-fit flex-nowrap flex-shrink-0 items-center justify-center rounded-full text-body font-bold transition-all hover:no-underline bg-lime1 hover:bg-lime2 text-gray1000 hover:text-gray1000 px-8 py-5 gap-x-2 [&amp;&gt;svg]:h-6 [&amp;&gt;svg]:w-6 whitespace-nowrap">RUN DIAGNOSTICS
                        </a>
                        <div class="flex-break hidden lg:flex xxl:hidden"></div>
                        <div class="w-auto items-center rounded-xl flex flex-nowrap bg-yellowLightWithOpacity p-1">
                            <div class="ui-flex-center rounded-[50%]">
                                <svg viewBox="0 0 25 25" class="h-6 w-6">
                                    <circle cx="12.5" cy="12.5" r="12.5" fill="#000"></circle>
                                    <path fill="#000" d="M17.912 17.11c-6.072 2.89-9.84.473-12.252-.996-.15-.092-.403.022-.183.275.803.974 3.437 3.323 6.875 3.323 3.44 0 5.486-1.877 5.742-2.205.255-.325.075-.504-.182-.396Zm1.706-.941c-.164-.212-.992-.252-1.513-.188-.523.062-1.306.381-1.238.573.035.072.106.04.465.007.36-.036 1.367-.163 1.577.112.211.276-.321 1.593-.418 1.805-.094.212.035.267.212.126.174-.142.489-.508.7-1.026.21-.52.338-1.247.214-1.41Z"></path>
                                    <path fill="#000" fill-rule="evenodd" d="M13.829 11.214c0 .758.019 1.39-.365 2.064-.309.547-.799.884-1.346.884-.748 0-1.183-.57-1.183-1.41 0-1.659 1.486-1.96 2.893-1.96v.422Zm1.962 4.743a.406.406 0 0 1-.46.047c-.646-.536-.76-.786-1.117-1.297-1.067 1.089-1.823 1.415-3.208 1.415-1.637 0-2.912-1.01-2.912-3.033 0-1.58.857-2.655 2.075-3.18 1.056-.466 2.532-.548 3.66-.677V8.98c0-.463.035-1.01-.236-1.41-.238-.358-.693-.506-1.092-.506-.742 0-1.404.38-1.566 1.169-.033.175-.161.347-.337.356L8.71 8.386c-.16-.036-.334-.164-.29-.408C8.855 5.69 10.92 5 12.772 5c.947 0 2.184.252 2.931.97.948.883.857 2.063.857 3.347v3.033c0 .911.378 1.31.734 1.804.126.175.153.386-.006.517-.397.331-1.103.947-1.492 1.292l-.005-.005" clip-rule="evenodd"></path>
                                    <path fill="#F90" d="M17.912 17.11c-6.072 2.89-9.84.473-12.252-.996-.15-.092-.403.022-.183.275.803.974 3.437 3.323 6.875 3.323 3.44 0 5.486-1.877 5.742-2.205.255-.325.075-.504-.182-.396Zm1.706-.941c-.164-.212-.992-.252-1.513-.188-.523.062-1.306.381-1.238.573.035.072.106.04.465.007.36-.036 1.367-.163 1.577.112.211.276-.321 1.593-.418 1.805-.094.212.035.267.212.126.174-.142.489-.508.7-1.026.21-.52.338-1.247.214-1.41Z"></path>
                                    <path fill="#fff" fill-rule="evenodd" d="M13.829 11.214c0 .758.019 1.39-.365 2.064-.309.547-.799.884-1.346.884-.748 0-1.183-.57-1.183-1.41 0-1.659 1.486-1.96 2.893-1.96v.422Zm1.962 4.743a.406.406 0 0 1-.46.047c-.646-.536-.76-.786-1.117-1.297-1.067 1.089-1.823 1.415-3.208 1.415-1.637 0-2.912-1.01-2.912-3.033 0-1.58.857-2.655 2.075-3.18 1.056-.466 2.532-.548 3.66-.677V8.98c0-.463.035-1.01-.236-1.41-.238-.358-.693-.506-1.092-.506-.742 0-1.404.38-1.566 1.169-.033.175-.161.347-.337.356L8.71 8.386c-.16-.036-.334-.164-.29-.408C8.855 5.69 10.92 5 12.772 5c.947 0 2.184.252 2.931.97.948.883.857 2.063.857 3.347v3.033c0 .911.378 1.31.734 1.804.126.175.153.386-.006.517-.397.331-1.103.947-1.492 1.292l-.005-.005" clip-rule="evenodd"></path>
                                </svg>
                            </div>
                            <div class="ml-2 pt-1 font-bold text-body text-white">4.6</div>
                            <div class="ui-flex-center ml-1">
                                <svg viewBox="0 0 16 16" fill="none" class="h-4 w-4 text-yellowDark">
                                    <path fill="currentColor" d="M14.948 6.088a1.023 1.023 0 0 0-.908-.71l-3.712-.26-1.377-3.467A1.02 1.02 0 0 0 8.001 1h-.002a1.02 1.02 0 0 0-.949.65L5.653 5.139l-3.692.24a1.023 1.023 0 0 0-.908.71 1.043 1.043 0 0 0 .322 1.13l2.84 2.4-.845 3.322a1.149 1.149 0 0 0 .439 1.22 1.115 1.115 0 0 0 1.254.04l2.93-1.857c.003-.003.007-.005.016 0l3.152 1.997a1.008 1.008 0 0 0 1.138-.035 1.04 1.04 0 0 0 .398-1.105l-.898-3.63 2.827-2.353a1.043 1.043 0 0 0 .322-1.129Z"></path>
                                </svg>
                            </div>
                        </div>
                        <div class="flex-break lg:hidden"></div>
                        <div class="flex items-center gap-x-3">
                            <div>
                                <span class="rounded-sm mr-1 bg-black10 px-1.5 py-1 text-body font-bold text-white">10+ </span>
                                <span class="whitespace-nowrap text-body font-bold text-white">Years in crypto </span>
                            </div>
                            <div>
                                <span class="rounded-sm mr-1 bg-black10 px-1.5 py-1 text-body font-bold text-white">2M+ </span>
                                <span class="whitespace-nowrap text-body font-bold text-white">Customers </span>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="hidden lg:mb-2 lg:flex lg:flex-row vl:mb-[5.5rem] vl:h-9 vl:flex-col vl:items-start vl:gap-y-3 xl:gap-3 xxl:mb-2 xxl:flex-row">
                    <div class="hidden whitespace-nowrap text-small font-bold text-gray300 vl:inline-block">Recommended by</div>
                    <div class="flex gap-2 lg:flex-row lg:items-center vl:flex-col vl:items-start vl:gap-y-3 xl:gap-3 xxl:flex-row xxl:items-center">
                        <svg width="79" height="22" viewBox="0 0 79 22" fill="none" class="text-white">
                            <path d="M8.093 2.539h1.7a5.6 5.6 0 0 1 3.055.396 5.53 5.53 0 0 1 2.445 3.344c.254.733.254.733.865.473h.477V.951H.639v1.023h.656a1.9 1.9 0 0 1 .825.185c.258.124.486.306.666.532.611 1.008.715 2.138.715 8.015 0 6.245-.134 7.771-.715 8.55-.144.2-.33.364-.544.48a1.6 1.6 0 0 1-.693.192c-.91.168-.91.152-.91.565a.63.63 0 0 0 0 .427h10.093a.98.98 0 0 0 0-.87 5 5 0 0 0-.746-.153 5 5 0 0 1-.805-.168 2.74 2.74 0 0 1-.867-1.096 2.8 2.8 0 0 1-.221-1.392c-.15-1.008-.224-2.855-.224-4.382v-1.206h.597a8 8 0 0 1 2.206.244c.345.219.64.513.86.861.222.349.366.743.422 1.155l.134.473h.91V7.622h-.835l-.135.657a2.76 2.76 0 0 1-.444 1.173c-.235.35-.548.638-.912.842a2.4 2.4 0 0 1-1.088.077H7.869V8.72c0-1.71.09-5.312.15-5.877zm69.766 12.106a5.43 5.43 0 0 0-3.086-2.397 7.4 7.4 0 0 1-2.668-1.526 1.5 1.5 0 0 1-.381-.625 1.56 1.56 0 0 1-.052-.734 1.84 1.84 0 0 1 .522-1.283c.226-.242.511-.416.826-.505a1.76 1.76 0 0 1 .963.002c.652.19 1.241.557 1.706 1.062.464.506.786 1.13.933 1.808.238.687.268.687.7.504l.269-.107V7.042l-.194-.091a11.3 11.3 0 0 0-4.577-.641 5.3 5.3 0 0 0-3.578 1.526c-.437.42-.78.932-1.004 1.502a4.3 4.3 0 0 0-.293 1.796 3.66 3.66 0 0 0 1.014 2.504 6 6 0 0 0 2.534 1.526c2.311.932 2.982 1.527 2.982 2.611a2.05 2.05 0 0 1-.403 1.268 1.97 1.97 0 0 1-1.088.732 3.6 3.6 0 0 1-1.58 0 4.6 4.6 0 0 1-1.775-1.265 4.74 4.74 0 0 1-1.013-1.956l-.194-.489h-.268q-.193.015-.373.092h-.149v4.336h.254a15 15 0 0 0 3.1.702h1.491a5.7 5.7 0 0 0 1.923-.183 4.6 4.6 0 0 0 2.156-1.047 4.75 4.75 0 0 0 1.362-2.007 3.6 3.6 0 0 0 .269-1.374 3.9 3.9 0 0 0-.328-1.939M63.816 6.752a6.73 6.73 0 0 0-5.62.138 6.6 6.6 0 0 0-2.138 1.713 6.8 6.8 0 0 0-1.276 2.455 8.3 8.3 0 0 0-.402 3.053 8.6 8.6 0 0 0 .134 1.68 6.83 6.83 0 0 0 1.84 3.591 6.57 6.57 0 0 0 3.512 1.874c.866.112 1.742.112 2.609 0a7.1 7.1 0 0 0 2.534-.992 4.5 4.5 0 0 0 1.58-1.527.77.77 0 0 0-.358-.473q-.256.095-.477.26a4.2 4.2 0 0 1-2.504.717 3.9 3.9 0 0 1-1.729-.275 4 4 0 0 1-1.447-1.008 3.6 3.6 0 0 1-.76-1.038 7.2 7.2 0 0 1-.73-3.053v-.596h8.258v-.305a8 8 0 0 0 0-.916 6.2 6.2 0 0 0-.816-3.067 6.04 6.04 0 0 0-2.21-2.23m-4.159 5.283h-1.043v-.901c.342-2.305 1.192-3.68 2.236-3.68 1.043 0 1.49 1.36 1.684 3.848v.702h-.894zM38.221 6.248a3.1 3.1 0 0 0-1.491.321 5.06 5.06 0 0 0-2.31 2.366l-.195.367V6.248h-.074c-.18 0-5.695 1.13-5.874 1.207-.179.076-.119.091-.119.366s0 .32.12.336l.58.122a1.05 1.05 0 0 1 .835.443c.373.504.448 1.389.448 5.16a30 30 0 0 1-.209 5.084 1.26 1.26 0 0 1-.36.664 1.2 1.2 0 0 1-.669.328l-.506.107h-.194v.428a.62.62 0 0 0 0 .442h8.333v-.442a1.1 1.1 0 0 0 0-.443q-.754-.03-1.49-.199a1.5 1.5 0 0 1-.627-.637 1.56 1.56 0 0 1-.164-.89c-.12-.885-.179-3.48-.149-5.465s0-2.107.164-2.244a2.64 2.64 0 0 1 1.744-.565 3.8 3.8 0 0 1 1.7.443q.275.155.581.229s1.49-3.695 1.49-3.863a1.76 1.76 0 0 0-.706-.508 1.7 1.7 0 0 0-.858-.103m-10.048 6.413a7 7 0 0 0-.892-3.1 6.8 6.8 0 0 0-2.179-2.335 7.6 7.6 0 0 0-6.977-.198 6.86 6.86 0 0 0-3.264 3.968 10.44 10.44 0 0 0 0 5.863 6.4 6.4 0 0 0 1.595 2.763 6 6 0 0 0 3.443 1.71q1.252.108 2.505 0 .46-.071.91-.198a6.6 6.6 0 0 0 3.146-2.002 6.86 6.86 0 0 0 1.609-3.418c.148-1.01.184-2.035.104-3.053m-6.201 7.633c-1.491.458-2.61-1.023-2.982-4.137a29.3 29.3 0 0 1 0-4.901c.298-2.504 1.059-3.77 2.236-3.77a1.46 1.46 0 0 1 .693.126c.218.098.41.248.56.438.998 1.023 1.49 3.053 1.49 6.107a11.56 11.56 0 0 1-.775 5.069c-.28.468-.713.82-1.222.992zm26.833-13.74a5 5 0 0 0-1.267 0c-.808 0-1.606.176-2.341.519l-.462.198V3.958a23 23 0 0 0 0-3.358c-.179 0-5.873 1.114-5.963 1.16a.5.5 0 0 0 0 .351c0 .32 0 .305.67.458q.285.065.538.214c.29.28.484.65.551 1.053a18 18 0 0 1 .164 3.512v13.404l.403.092c.596.137 2.28.427 2.832.488 1.101.09 2.208.09 3.31 0a6.66 6.66 0 0 0 3.37-1.35 6.9 6.9 0 0 0 2.205-2.94 10.7 10.7 0 0 0 .566-2.32 14 14 0 0 0-.104-3.222 5.94 5.94 0 0 0-1.475-3.195 5.7 5.7 0 0 0-2.997-1.751m-3.906 13.48c0-.198-.15-6.885-.12-9.557V8.386l.433-.107q.44-.064.88 0c.322-.034.647.041.924.214a4.54 4.54 0 0 1 1.352 1.514c.333.603.528 1.275.57 1.967a17 17 0 0 1 0 3.343A7.44 7.44 0 0 1 47.21 19.7c-.292.285-.66.476-1.058.55-.3.053-.608.053-.91 0-.282 0-.282-.092-.282-.214z" fill="currentColor"></path>
                        </svg>
                        <svg width="106" height="21" viewBox="0 0 106 21" fill="none" class="text-white">
                            <path d="M9.738 10.697c0 .562.435 1 .993 1a.985.985 0 0 0 .993-1c0-.562-.436-1-.993-1a1.01 1.01 0 0 0-.993 1m8.328-.983a.985.985 0 0 0-.993 1c0 .562.435 1 .993 1a.985.985 0 0 0 .993-1c0-.561-.436-1-.993-1m0 7.512a.985.985 0 0 0-.993 1c0 .562.435 1 .993 1a.985.985 0 0 0 .993-1c0-.561-.436-1-.993-1" fill="currentColor"></path>
                            <path d="M20.175 1.448c-.993-1.247-2.77-1.3-3.815-.316l-.122.122-.244.194a2.546 2.546 0 0 1-3.398-.194v-.07A2.7 2.7 0 0 0 11.429.5c-.07 0-.192-.07-.244-.07h-.993c-.07 0-.122 0-.192.07h-.122c-.07 0-.122.07-.192.07 0 0-.07 0-.07.07-.069 0-.121.07-.191.07 0 0-.07 0-.07.07-.07.07-.122.07-.191.123 0 0-.07 0-.07.07-.07.07-.122.07-.192.124l-.191.193-.244.193c-.993.807-2.474.737-3.328-.193 0 0-.07 0-.07-.07l-.122-.123C4.581.78 4.146.535 3.657.482H2.544c0 .07-.07.07-.122.123h-.018c-.313.123-.61.246-.87.492l-.262.263c-.244.246-.366.561-.488.807 0 .07-.07.123-.07.193s-.07.123-.07.246c-.07.439-.07.877.07 1.299 0 .07.07.123.07.193v.07c0 .07.07.123.07.193.07.07.07.123.122.246.122.07.244.193.313.245l.244.246c.924.93.924 2.545-.07 3.545-.121.123-.313.316-.365.44-.07.07-.07.122-.122.245v.07c-.07.07-.07.123-.122.193v.07c0 .07-.07.123-.07.193v.07c0 .07 0 .124-.07.194v.93c0 .07 0 .123.07.193v.07c.122.439.366.878.732 1.246.993 1 .993 2.615 0 3.598l-.192.193v.07c-.07.07-.122.123-.122.194 0 0 0 .07-.07.07-.07.07-.07.123-.122.193l-.07.07c0 .07-.069.07-.069.123s-.07.07-.07.123c0 .07 0 .07-.07.123a2 2 0 0 0-.19.807v.491c.069.194.069.369.19.492 0 .07.07.123.07.123s0 .07.07.07c0 .07.07.123.07.193 0 0 0 .07.07.07.07.123.121.193.191.246 0 0 0 .07.07.07 0 0 0 .07.07.07 0 .07.07.07.07.07l.069.07c.07.07.122.07.122.124l.07.07s.07 0 .07.07c.069.07.121.123.19.123 0 0 .07 0 .07.07.07.07.123.07.192.123h.035c.07.07.122.07.244.07.07 0 .192.07.244.07h.07c.07 0 .122 0 .191.07h.558c.192 0 .314-.07.488-.07h.07c.07 0 .121-.07.191-.07h.035c.07 0 .122-.07.192-.07h.07c.121-.07.313-.193.435-.246l.261-.263c.993-1.053 2.596-1.053 3.572 0 1.115 1.176 2.962 1.123 4.007-.193.732-.93.732-2.3 0-3.3-.993-1.246-2.77-1.299-3.815-.316l-.122.123-.244.193a2.546 2.546 0 0 1-3.398-.193l-.122-.123-.191-.245c-.802-1-.732-2.493.191-3.423.558-.491.802-1.176.802-1.86v-.193a2.27 2.27 0 0 0-.732-1.685c0-.07-.07-.07-.07-.123l-.191-.246c-.802-1-.732-2.492.191-3.422l.14-.14c.993-1.054 2.596-1.054 3.571 0l.262.263c.07 0 .07.07.122.07s.07.07.122.07.07.07.122.07.07.07.122.07.07.07.122.07.07.07.122.07.07 0 .122.071c.07 0 .07 0 .121.07h1.046c.07 0 .122 0 .192-.07h.121c.07 0 .123-.07.192-.07h.07c.07 0 .122-.07.244-.123a3.2 3.2 0 0 0 .68-.491l.069-.07c.993-1.054 2.596-1.054 3.572 0 1.045 1.246 2.962 1.175 3.955-.123.662-1.141.662-2.51-.07-3.44m14.06 7.705c-.366-.37-.68-.615-1.115-.808-.366-.193-.802-.316-1.36-.316-.487 0-.992.123-1.358.316s-.68.439-.924.807a3.2 3.2 0 0 0-.557 1.124 5 5 0 0 0-.192 1.299c0 .42.07.877.244 1.298.122.44.366.738.61 1.053.244.316.61.562.993.738.366.193.801.245 1.29.245.557 0 .992-.123 1.358-.316a3.4 3.4 0 0 0 1.046-.807l1.29 1.369a4.2 4.2 0 0 1-1.673 1.176q-.915.369-2.04.368c-.73 0-1.48-.122-2.09-.368a4.8 4.8 0 0 1-1.603-1.053c-.435-.439-.801-1-1.045-1.615-.244-.614-.366-1.369-.366-2.106s.122-1.492.366-2.106a6 6 0 0 1 1.045-1.685 4.8 4.8 0 0 1 1.603-1.053c.61-.246 1.36-.369 2.09-.369a5.5 5.5 0 0 1 2.04.369c.679.246 1.236.684 1.724 1.176zm4.182 2.299c0 .491.07 1 .243 1.369.122.438.366.807.61 1.123s.61.562.993.684c.366.194.872.246 1.36.246.487 0 .923-.07 1.358-.246.366-.193.732-.438.994-.684.243-.316.488-.685.61-1.123.121-.44.243-.878.243-1.37 0-.49-.07-1-.244-1.368-.121-.44-.366-.808-.61-1.124a2.1 2.1 0 0 0-.992-.684c-.366-.193-.872-.246-1.36-.246-.487 0-.923.07-1.359.246a4.7 4.7 0 0 0-.993.684c-.244.316-.488.685-.61 1.124-.122.438-.244.877-.244 1.369m-1.97 0q0-1.107.367-2.054a5 5 0 0 1 1.115-1.685c.487-.491.993-.877 1.672-1.123.61-.246 1.29-.439 2.039-.439s1.411.123 2.038.439c.61.246 1.168.614 1.673 1.123.488.492.802 1.053 1.115 1.685q.366.921.366 2.054 0 1.105-.366 2.053a5 5 0 0 1-1.115 1.685c-.488.492-.993.807-1.673 1.123-.61.246-1.289.44-2.038.44-.732 0-1.411-.124-2.039-.44a4.9 4.9 0 0 1-1.672-1.123c-.488-.491-.802-1-1.115-1.685-.175-.632-.366-1.316-.366-2.053m12.284 5.037h1.847V6.555h-1.847zm-.435-13.55c0-.368.122-.684.366-1 .243-.246.557-.439.923-.439s.68.123.923.439c.244.246.366.614.366 1 0 .387-.122.685-.366 1-.244.247-.557.44-.923.44s-.68-.123-.923-.44c-.244-.262-.366-.631-.366-1m4.86 3.598h1.865v1.545h.07c.244-.562.61-1 1.237-1.299.557-.316 1.237-.491 2.038-.491.488 0 .924.07 1.36.245.435.123.8.369 1.114.685s.558.684.802 1.176c.192.491.313 1.053.313 1.737v6.406h-1.881v-5.897c0-.438-.07-.877-.192-1.176a2.8 2.8 0 0 0-.488-.807c-.191-.193-.435-.369-.732-.439a3.3 3.3 0 0 0-.87-.123c-.367 0-.732.07-1.046.193a2.2 2.2 0 0 0-.871.615c-.244.245-.436.614-.558 1.053s-.191.93-.191 1.492v5.16H53.28V6.555m15.49 8.372c.487 0 .922-.07 1.358-.246.436-.193.732-.439 1.046-.737.243-.316.487-.685.61-1.123.121-.44.243-.878.243-1.422 0-.491-.07-1-.244-1.422-.122-.438-.366-.807-.61-1.123-.313-.316-.61-.562-1.045-.737-.436-.193-.871-.246-1.359-.246s-.923.07-1.359.246c-.435.193-.732.439-1.045.737-.244.316-.488.685-.61 1.123-.122.44-.244.878-.244 1.422 0 .492.07 1 .244 1.422.122.438.366.807.61 1.123s.61.562 1.045.737c.366.123.871.246 1.36.246m5.122 1.492h-1.847v-1.422h-.07c-.366.562-.871.93-1.481 1.246s-1.29.439-1.969.439c-.732 0-1.48-.123-2.09-.369a4.1 4.1 0 0 1-1.604-1.123c-.435-.491-.801-1.053-.993-1.685q-.366-.921-.366-2.053c0-.755.122-1.422.366-2.106a5.9 5.9 0 0 1 .993-1.685 4.3 4.3 0 0 1 1.603-1.124c.61-.245 1.29-.368 2.091-.368.68 0 1.36.123 1.969.439.61.316 1.115.737 1.411 1.246h.07V.394h1.847V16.42zm9.426-5.775c0-.438-.07-.807-.192-1.176a2.4 2.4 0 0 0-.558-.93c-.243-.246-.557-.439-.87-.614-.367-.123-.732-.246-1.238-.246-.435 0-.871.07-1.237.246-.366.193-.68.368-.993.684-.244.246-.488.562-.61.93-.122.37-.244.685-.244 1.001H83.3zM77.41 12.19c0 .439.122.807.314 1.176.191.368.435.684.732.93.313.246.679.439 1.045.562.436.122.801.193 1.237.193.557 0 1.115-.123 1.533-.44.436-.245.802-.613 1.168-1.052l1.41 1.123c-1.044 1.369-2.525 2.054-4.372 2.054-.802 0-1.481-.123-2.091-.369a4.1 4.1 0 0 1-1.603-1.123c-.436-.492-.802-1-.993-1.685q-.366-.921-.366-2.054 0-1.105.366-2.053a6 6 0 0 1 1.045-1.685c.436-.491.993-.807 1.603-1.123q.915-.369 2.039-.369c.87 0 1.603.123 2.212.439s1.115.684 1.481 1.176.68 1.053.871 1.685c.192.614.245 1.246.245 1.93v.685zm15.158-3.16c-.243-.245-.487-.49-.801-.684A2.27 2.27 0 0 0 90.6 8.03c-.436 0-.802.123-1.168.316-.313.193-.488.439-.488.807 0 .316.122.562.314.685.192.193.436.316.68.439.243.123.557.193.801.245.314.07.558.123.732.123.366.123.801.193 1.115.369.366.123.68.316.923.562.244.245.436.491.61.807.122.316.244.684.244 1.176 0 .561-.122 1.053-.366 1.421s-.557.738-.923 1c-.366.264-.802.44-1.29.563a6 6 0 0 1-1.41.192c-.802 0-1.534-.122-2.161-.368-.61-.246-1.168-.684-1.673-1.369l1.411-1.176c.314.316.61.562.993.807.384.246.802.369 1.36.369.243 0 .487 0 .731-.07s.436-.123.61-.246c.192-.123.314-.246.436-.368.122-.194.191-.37.191-.562 0-.246-.07-.492-.244-.685a2.2 2.2 0 0 0-.61-.438 3 3 0 0 0-.731-.246l-.732-.193c-.366-.123-.802-.193-1.115-.316a3.5 3.5 0 0 1-.924-.491 3.2 3.2 0 0 1-.68-.808c-.19-.316-.243-.737-.243-1.176 0-.491.122-1 .314-1.369.191-.368.487-.684.87-.93a4 4 0 0 1 1.168-.562 5.2 5.2 0 0 1 1.36-.193c.679 0 1.288.123 1.916.369.61.246 1.115.684 1.48 1.246zM96.16.64h1.846v10.057l4.2-4.23h2.526l-4.495 4.476 4.931 5.335h-2.649l-4.495-5.09v5.09h-1.847V.64" fill="currentColor"></path>
                        </svg>
                        <svg width="100" height="16" viewBox="0 0 100 16" fill="none" class="-ml-1 h-5 w-32 text-white">
                            <g fill="currentColor" clip-path="url(#a)">
                                <path d="m6.998 11.006-1.082-.67.414-3.822-4.557 2.72a6.1 6.1 0 0 0 2.742 2.6 6.3 6.3 0 0 0 3.783.52 6.2 6.2 0 0 0 3.368-1.762 5.97 5.97 0 0 0 1.657-3.366z"></path>
                                <path fill-rule="evenodd" clip-rule="evenodd" d="m7.902 5.251-1.083-.669-5.563 3.324a5.9 5.9 0 0 1-.141-2.446c.125-.817.42-1.599.867-2.299a6.1 6.1 0 0 1 1.732-1.77 6.2 6.2 0 0 1 2.31-.95 6.3 6.3 0 0 1 2.505.03 6.2 6.2 0 0 1 2.286 1.003 6.1 6.1 0 0 1 1.688 1.81c.43.71.705 1.5.81 2.319L7.488 9.076zm.511-2.07c0 .47-.39.852-.87.852a.86.86 0 0 1-.871-.852c0-.47.39-.85.87-.85a.86.86 0 0 1 .871.85"></path>
                                <path d="m16.445 11.975 1.53-.022V1.386l-1.53.022zm7.314-7.342c-.685 0-1.85.297-2.366 1.105v-.955H19.95v7.192h1.443V8.083c0-1.418 1.095-2.054 2.18-2.054 1.025 0 1.71.753 1.71 1.872v4.074h1.441v-4.15c0-1.022-.287-1.858-.855-2.416-.513-.509-1.243-.776-2.11-.776m7.306 5.492-2.208-5.34h-1.544l3.054 7.19h1.382l3.07-7.19h-1.56zm26.939-5.492c-2.224 0-3.84 1.565-3.84 3.724s1.652 3.77 3.84 3.77a3.8 3.8 0 0 0 1.49-.261 3.8 3.8 0 0 0 1.265-.815c.36-.353.644-.773.834-1.236s.28-.96.267-1.458c0-2.159-1.614-3.724-3.856-3.724m0 6.16c-1.35 0-2.376-1.048-2.376-2.436 0-1.363 1.026-2.39 2.38-2.39.321-.004.64.055.936.174s.565.295.79.519a2.28 2.28 0 0 1 .682 1.698c0 1.387-1.037 2.434-2.412 2.434m8.84-6.16c-1.065 0-2.04.453-2.536 1.17v-1.02h-1.444v10.644h1.444V10.97c.492.724 1.431 1.15 2.551 1.15 2.126 0 3.669-1.571 3.669-3.739 0-2.167-1.55-3.75-3.684-3.75m-.125 6.16a2.5 2.5 0 0 1-.931-.181 2.4 2.4 0 0 1-.788-.52 2.4 2.4 0 0 1-.52-.776 2.3 2.3 0 0 1-.172-.914c0-1.388 1.036-2.435 2.411-2.435 1.319 0 2.35 1.07 2.35 2.435s-1.01 2.39-2.35 2.39m18.865-5.006c-.493-.725-1.432-1.151-2.552-1.151-2.126 0-3.669 1.572-3.669 3.74 0 2.167 1.55 3.754 3.684 3.754 1.066 0 2.04-.453 2.537-1.17v1.015h1.443V.906h-1.443zm-2.42 5.005c-1.31 0-2.335-1.07-2.335-2.435s.997-2.39 2.335-2.39a2.42 2.42 0 0 1 1.726.697 2.3 2.3 0 0 1 .7 1.693c-.006 1.18-.856 2.435-2.426 2.435m5.69-6.007h1.443v7.19h-1.443zm10.272-.002h-1.444v.836c-.513-.625-1.397-.99-2.43-.99h-.116c-2.126 0-3.669 1.572-3.669 3.74 0 2.167 1.55 3.755 3.684 3.755h.121c.984 0 1.892-.389 2.415-1.004v.855h1.553V4.783zm-3.81 6.004c-1.28-.033-2.274-1.087-2.274-2.432S94.017 6 95.317 5.97c1.326.023 2.383 1.09 2.365 2.386 0 1.166-.836 2.4-2.365 2.434zM45.935 7.58c-.754-.189-1.288-.357-1.288-.817 0-.517.534-.878 1.3-.878.556.01 1.092.2 1.527.538l.036.027.775-1.05-.034-.027a3.8 3.8 0 0 0-2.395-.771c-1.301 0-2.702.7-2.702 2.236 0 1.07.913 1.592 1.678 1.84.256.083.513.148.773.212.799.2 1.49.375 1.49.983 0 .427-.44.878-1.254.878a3.56 3.56 0 0 1-2.114-.764l-.038-.027-.773 1.08.033.026a4.64 4.64 0 0 0 2.925.968c1.316 0 2.717-.767 2.717-2.19S47.249 7.91 45.935 7.58m32.49.678c0-2.146-1.418-3.641-3.47-3.641-2.074 0-3.58 1.533-3.58 3.644a3.7 3.7 0 0 0 .265 1.48c.188.471.471.9.832 1.263a3.46 3.46 0 0 0 2.416.948h.069c1.27-.021 2.1-.227 3.108-1.29l.03-.033-1-.931-.031.033c-.253.29-.569.523-.925.68a2.7 2.7 0 0 1-1.133.227c-1.115 0-1.994-.8-2.2-1.996l5.57-.011h.04v-.04q.009-.099 0-.196c.011-.027.01-.064.01-.137m-5.399-.726c.19-1.039.886-1.61 1.965-1.61 1.045 0 1.757.6 1.914 1.61zm-30.908.726c0-2.146-1.428-3.641-3.467-3.641-2.075 0-3.58 1.533-3.58 3.644a3.7 3.7 0 0 0 .265 1.48c.188.471.47.9.832 1.263a3.46 3.46 0 0 0 2.416.948h.067c1.272-.021 2.102-.227 3.11-1.29l.03-.033-1-.931-.031.033c-.254.291-.57.524-.927.68a2.7 2.7 0 0 1-1.136.227c-1.117 0-1.994-.8-2.201-1.996l5.569-.011h.042v-.04a1.4 1.4 0 0 0 0-.196c.01-.027.01-.064.01-.137m-5.405-.726c.192-1.039.888-1.61 1.967-1.61 1.045 0 1.756.6 1.914 1.61zm16.607 2.95a2.2 2.2 0 0 1-.609.072 1.22 1.22 0 0 1-.894-.334c-.158-.181-.19-.459-.19-.818v-3.39h2.052V4.783h-2.052V2.455H50.18v2.328h-.794v1.23h.794v3.314c0 .798.181 1.385.554 1.793.243.263.543.47.877.607s.695.2 1.057.186c.363.003.724-.045 1.073-.144l.042-.013-.422-1.287zM89.575 1.34a.94.94 0 0 0-.659.27.9.9 0 0 0-.264.649.87.87 0 0 0 .266.642.9.9 0 0 0 .657.26.94.94 0 0 0 .666-.257.9.9 0 0 0 .206-.998.9.9 0 0 0-.51-.498 1 1 0 0 0-.362-.068"></path>
                            </g>
                            <defs>
                                <clippath id="a">
                                    <path fill="currentColor" d="M.898.268h98.341v15.22H.898z"></path>
                                </clippath>
                            </defs>
                        </svg>
                    </div>
                </div>
            </div>
        </div>
        <div class="container mx-auto max-w-container bg-gray100 pb-2 pt-8 xxl:pt-4">
            <div class="px-2 lg:px-4 vl:px-10 xxl:px-18">
                <div class="mb-20 xxl:mb-32">
                    <div class="mb-6 flex flex-col items-start gap-2 md:mb-6 md:flex-row md:items-end lg:mb-8 xxl:mb-12">
                        <div class="ui-typo-h1 mb-3 font-medium tracking-tight text-gray1000 md:mb-0 md:grow">
                            Why a <br/>hardware wallet?

                        </div>
                        <a href="https://trezor.io/security" class="flex w-fit flex-nowrap flex-shrink-0 items-center justify-center rounded-full text-body font-bold transition-all hover:no-underline bg-primary hover:bg-primaryDarker text-white hover:text-white px-8 py-5 gap-x-2 [&amp;&gt;svg]:h-6 [&amp;&gt;svg]:w-6 mr-4">More about security
                        </a>
                    </div>
                    <div class="rounded-lg bg-white px-8 py-8 md:flex md:p-12 lg:px-16 lg:pb-24 lg:pt-20 xxl:px-28 mb-4">
                        <div class="flex-auto border-b border-gray300 pb-8 md:border-b-0 md:border-r md:p-0 md:pr-12 lg:pr-16 xxl:pr-36">
                            <div class="mb-3 font-medium text-h4 tracking-tight text-gray1000 md:mb-5 md:text-[40px] lg:text-h3">
                                <span class="block xs:inline md:block xl:inline">Online </span>
                                exchanges
                            </div>
                            <div class="flex flex-col gap-y-1 md:gap-y-3">
                                <div class="flex items-center gap-x-4">
                                    <svg viewBox="0 0 33 33" fill="none" class="h-8 w-8 shrink-0">
                                        <path d="M33 16.5C33 25.0767 24.1061 33 15.5294 33C6.95275 33 0 26.0472 0 17.4706C0 8.89393 7.92334 0 16.5 0C25.0767 0 33 7.92334 33 16.5Z" fill="#171717"></path>
                                        <circle cx="17" cy="16" r="15.25" fill="#D9D9D9" stroke="black" stroke-width="1.5"></circle>
                                        <path d="M21.5 11.5L12.5 20.5" stroke="black" stroke-width="1.5"></path>
                                        <path d="M21.5 20.5L12.5 11.5" stroke="black" stroke-width="1.5"></path>
                                    </svg>
                                    <div class="text-highlight lg:text-h5 xl:whitespace-nowrap text-gray700">You don’t truly own your coins</div>
                                </div>
                                <div class="flex items-center gap-x-4">
                                    <svg viewBox="0 0 33 33" fill="none" class="h-8 w-8 shrink-0">
                                        <path d="M33 16.5C33 25.0767 24.1061 33 15.5294 33C6.95275 33 0 26.0472 0 17.4706C0 8.89393 7.92334 0 16.5 0C25.0767 0 33 7.92334 33 16.5Z" fill="#171717"></path>
                                        <circle cx="17" cy="16" r="15.25" fill="#D9D9D9" stroke="black" stroke-width="1.5"></circle>
                                        <path d="M21.5 11.5L12.5 20.5" stroke="black" stroke-width="1.5"></path>
                                        <path d="M21.5 20.5L12.5 11.5" stroke="black" stroke-width="1.5"></path>
                                    </svg>
                                    <div class="text-highlight lg:text-h5 xl:whitespace-nowrap text-gray700">Exchanges are targets for hackers</div>
                                </div>
                                <div class="flex items-center gap-x-4">
                                    <svg viewBox="0 0 33 33" fill="none" class="h-8 w-8 shrink-0">
                                        <path d="M33 16.5C33 25.0767 24.1061 33 15.5294 33C6.95275 33 0 26.0472 0 17.4706C0 8.89393 7.92334 0 16.5 0C25.0767 0 33 7.92334 33 16.5Z" fill="#171717"></path>
                                        <circle cx="17" cy="16" r="15.25" fill="#D9D9D9" stroke="black" stroke-width="1.5"></circle>
                                        <path d="M21.5 11.5L12.5 20.5" stroke="black" stroke-width="1.5"></path>
                                        <path d="M21.5 20.5L12.5 11.5" stroke="black" stroke-width="1.5"></path>
                                    </svg>
                                    <div class="text-highlight lg:text-h5 xl:whitespace-nowrap text-gray700">Your personal data may be exposed</div>
                                </div>
                            </div>
                        </div>
                        <div class="flex-auto pt-8 md:p-0 md:pl-12 lg:pl-16 xxl:pl-36">
                            <div class="mb-3 font-medium text-h4 tracking-tight text-gray1000 md:mb-5 md:text-[40px] lg:text-h3">
                                <div class="underline-headline xl:underline-headline md:underline-headline-none xxl:pr-[5.7rem]">
                                    <span class="block xs:inline md:block xl:inline">Go offline </span>
                                    <span class="md:underline-headline xl:underline-headline-none">with Trezor </span>
                                </div>
                            </div>
                            <div class="flex flex-col gap-y-1 md:gap-y-3">
                                <div class="flex items-center gap-x-4">
                                    <svg class="h-8 w-8 shrink-0" viewBox="0 0 24 24" fill="none">
                                        <path d="M10.105 4.494c-1.998 0-3.943-1.066-5.605.006C2.838 5.572 1.534 8.733.77 10.515a9.437 9.437 0 0 0-.576 5.635 9.652 9.652 0 0 0 2.766 4.993 10.223 10.223 0 0 0 5.174 2.67c1.96.376 3.992.183 5.838-.555C15.82 22.519 18.89 20.604 20 19c1.11-1.604.21-2.824.21-4.753-.005-2.585-1.07-5.063-2.965-6.89-1.894-1.829-4.461-2.858-7.14-2.863Zm4.81 8.046-5.694 5.252a.803.803 0 0 1-.544.206.772.772 0 0 1-.534-.206l-2.847-2.626a.753.753 0 0 1-.266-.53.726.726 0 0 1 .213-.551.778.778 0 0 1 .56-.234.8.8 0 0 1 .561.227l2.313 2.129 5.17-4.755a.795.795 0 0 1 1.074.05c.138.14.215.327.214.52a.737.737 0 0 1-.22.518Z" fill="#000"></path>
                                        <path d="M12.001 1.75H12A10.25 10.25 0 1 0 22.25 12v-.001A10.269 10.269 0 0 0 12.001 1.75Zm-1.376 13.5h-.01a.222.222 0 0 1-.159-.063l-.004-.005-2.747-2.625-.008-.008-.009-.007a.25.25 0 1 1 .344-.362l.007.006.007.007 2.23 2.128.346.33.345-.33 4.977-4.743a.25.25 0 0 1 .343.363l-5.484 5.24a.259.259 0 0 1-.178.069Z" fill="#9BE887" stroke="#000"></path>
                                    </svg>
                                    <div class="text-highlight lg:text-h5 xl:whitespace-nowrap text-primary">You own 100% of your coins</div>
                                </div>
                                <div class="flex items-center gap-x-4">
                                    <svg class="h-8 w-8 shrink-0" viewBox="0 0 24 24" fill="none">
                                        <path d="M10.105 4.494c-1.998 0-3.943-1.066-5.605.006C2.838 5.572 1.534 8.733.77 10.515a9.437 9.437 0 0 0-.576 5.635 9.652 9.652 0 0 0 2.766 4.993 10.223 10.223 0 0 0 5.174 2.67c1.96.376 3.992.183 5.838-.555C15.82 22.519 18.89 20.604 20 19c1.11-1.604.21-2.824.21-4.753-.005-2.585-1.07-5.063-2.965-6.89-1.894-1.829-4.461-2.858-7.14-2.863Zm4.81 8.046-5.694 5.252a.803.803 0 0 1-.544.206.772.772 0 0 1-.534-.206l-2.847-2.626a.753.753 0 0 1-.266-.53.726.726 0 0 1 .213-.551.778.778 0 0 1 .56-.234.8.8 0 0 1 .561.227l2.313 2.129 5.17-4.755a.795.795 0 0 1 1.074.05c.138.14.215.327.214.52a.737.737 0 0 1-.22.518Z" fill="#000"></path>
                                        <path d="M12.001 1.75H12A10.25 10.25 0 1 0 22.25 12v-.001A10.269 10.269 0 0 0 12.001 1.75Zm-1.376 13.5h-.01a.222.222 0 0 1-.159-.063l-.004-.005-2.747-2.625-.008-.008-.009-.007a.25.25 0 1 1 .344-.362l.007.006.007.007 2.23 2.128.346.33.345-.33 4.977-4.743a.25.25 0 0 1 .343.363l-5.484 5.24a.259.259 0 0 1-.178.069Z" fill="#9BE887" stroke="#000"></path>
                                    </svg>
                                    <div class="text-highlight lg:text-h5 xl:whitespace-nowrap text-primary">Your wallet is 100% safe offline</div>
                                </div>
                                <div class="flex items-center gap-x-4">
                                    <svg class="h-8 w-8 shrink-0" viewBox="0 0 24 24" fill="none">
                                        <path d="M10.105 4.494c-1.998 0-3.943-1.066-5.605.006C2.838 5.572 1.534 8.733.77 10.515a9.437 9.437 0 0 0-.576 5.635 9.652 9.652 0 0 0 2.766 4.993 10.223 10.223 0 0 0 5.174 2.67c1.96.376 3.992.183 5.838-.555C15.82 22.519 18.89 20.604 20 19c1.11-1.604.21-2.824.21-4.753-.005-2.585-1.07-5.063-2.965-6.89-1.894-1.829-4.461-2.858-7.14-2.863Zm4.81 8.046-5.694 5.252a.803.803 0 0 1-.544.206.772.772 0 0 1-.534-.206l-2.847-2.626a.753.753 0 0 1-.266-.53.726.726 0 0 1 .213-.551.778.778 0 0 1 .56-.234.8.8 0 0 1 .561.227l2.313 2.129 5.17-4.755a.795.795 0 0 1 1.074.05c.138.14.215.327.214.52a.737.737 0 0 1-.22.518Z" fill="#000"></path>
                                        <path d="M12.001 1.75H12A10.25 10.25 0 1 0 22.25 12v-.001A10.269 10.269 0 0 0 12.001 1.75Zm-1.376 13.5h-.01a.222.222 0 0 1-.159-.063l-.004-.005-2.747-2.625-.008-.008-.009-.007a.25.25 0 1 1 .344-.362l.007.006.007.007 2.23 2.128.346.33.345-.33 4.977-4.743a.25.25 0 0 1 .343.363l-5.484 5.24a.259.259 0 0 1-.178.069Z" fill="#9BE887" stroke="#000"></path>
                                    </svg>
                                    <div class="text-highlight lg:text-h5 xl:whitespace-nowrap text-primary">Your data is 100% anonymous</div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="relative flex aspect-video h-full min-h-[27.25rem] w-full items-end overflow-hidden rounded-xl px-8 md:min-w-[32.5rem] md:px-10 lg:min-h-[35rem] vl:min-h-[43.75rem] vl:px-20">
                        <div class="absolute bottom-0 left-0 right-0 top-0 z-belowMenuAndBlur mx-auto my-0 h-full w-auto min-w-[300px] max-w-container overflow-hidden text-center">
                            <video autoplay="" playsinline="" muted="" class="will-change-scroll absolute bottom-0 left-0 right-0 top-0 mx-auto min-h-full object-cover w-full overflow-hidden rounded-lg" width="1296" height="700" poster="em5dgJhJJQ/img/how-to-connect-ts5-desktop.jpg" src="em5dgJhJJQ/media/trezor-2.html"></video>
                            <img class="absolute bottom-0 left-0 right-0 top-0 mx-auto min-h-full object-cover w-full overflow-hidden rounded-lg hidden" src="em5dgJhJJQ/img/how-to-connect-ts5-desktop.jpg" width="1296" height="700"/>
                        </div>
                        <div class="z-belowMenu mb-2 flex max-h-12 grow flex-col justify-end md:flex-row md:justify-center md:gap-x-3">
                            <div class="flex items-end">
                                <div class="flex flex-row items-center gap-x-4 rounded-md py-2 text-body text-gray900 md:ml-0 lg:text-h6">
                                    <div class="flex shrink-0 items-center justify-center rounded-full h-6 w-6 bg-primary lg:h-8 lg:w-8 [&amp;&gt;svg]:h-5 [&amp;&gt;svg]:w-5">
                                        <svg class="h-6 w-6 text-white" viewBox="0 0 24 24" fill="none">
                                            <path d="M8.738 11.512a6.75 6.75 0 1 1 3.75 3.75L11.25 16.5H9v2.25H6.75V21H3v-3.75l5.738-5.738Z" stroke="currentColor"></path>
                                            <path d="M16.875 8.063a.937.937 0 1 0 0-1.875.937.937 0 0 0 0 1.875Z" fill="currentColor"></path>
                                        </svg>
                                    </div>
                                    No experience needed

                                </div>
                            </div>
                            <div class="flex items-end">
                                <div class="flex flex-row items-center gap-x-4 rounded-md py-2 text-body text-gray900 md:ml-0 lg:text-h6">
                                    <div class="flex shrink-0 items-center justify-center rounded-full h-6 w-6 bg-primary lg:h-8 lg:w-8 [&amp;&gt;svg]:h-5 [&amp;&gt;svg]:w-5">
                                        <svg class="h-6 w-6 text-white" viewBox="0 0 24 24" fill="none">
                                            <path d="M12 14.25c5.385 0 9.75-2.015 9.75-4.5s-4.365-4.5-9.75-4.5-9.75 2.015-9.75 4.5 4.365 4.5 9.75 4.5Zm0 0v4.5" stroke="currentColor"></path>
                                            <path d="M2.25 9.75v4.5c0 2.25 3.75 4.5 9.75 4.5s9.75-2.25 9.75-4.5v-4.5M18 13.322v4.5m-12-4.5v4.5" stroke="currentColor"></path>
                                        </svg>
                                    </div>
                                    No minimum amount needed

                                </div>
                            </div>
                            <div class="flex items-end">
                                <div class="flex flex-row items-center gap-x-4 rounded-md py-2 text-body text-gray900 md:ml-0 lg:text-h6">
                                    <div class="flex shrink-0 items-center justify-center rounded-full h-6 w-6 bg-primary lg:h-8 lg:w-8 [&amp;&gt;svg]:h-5 [&amp;&gt;svg]:w-5">
                                        <svg class="h-6 w-6 text-white" viewBox="0 0 24 24" fill="none">
                                            <path d="m13.875 7.875-8.25 8.25L1.5 12m20.998-4.125-8.25 8.25-2.193-2.194" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                                        </svg>
                                    </div>
                                    Simple setup and use

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div style="background: url(em5dgJhJJQ/img/ts5.jpg);" class="ui-spacer bg-[url('em5dgJhJJQ/img/ts5_mobile.html')] bg-cover md:bg-[url('em5dgJhJJQ/img/ts5_tablet.html')] md:bg-center vl:bg-[url('em5dgJhJJQ/img/ts5.jpg')] relative min-h-[30rem] w-full overflow-hidden rounded-lg sm:min-h-[38rem] md:h-full md:min-h-[30rem] lg:min-h-[40rem] vl:min-h-[38.6rem] flex flex-col content-center items-center">
                    <div class="relative z-belowMenuAndBlur flex h-full w-full grow flex-col items-stretch justify-start gap-y-2 p-8 md:p-10 lg:justify-between lg:gap-y-0 vl:gap-y-6 vl:p-20">
                        <h1 class="rendering-legibility font-medium break-words text-h3 leading-[2.75rem] rendering-legibility lg:text-h2 lg:leading-[5rem] vl:text-h1 ui-typo-h1 text-white">Say Hi, Trezor Safe 5</h1>
                        <p class="mt-2 max-w-[20.1rem] grow text-body md:mt-0 lg:mt-4 lg:max-w-[23.1rem] lg:text-highlight vl:mt-auto vl:max-w-[33.2rem] text-white">Crypto security &amp;convenience in a gorgeous design. The EAL6+ Secure Element adds asset protection while the bright, vibrant color touchscreen &amp;haptic feedback bring a new level to your crypto
                            experience.
                        </p>
                        <a href="https://trezor.io/trezor-safe-5" class="flex w-fit flex-nowrap flex-shrink-0 items-center justify-center rounded-full text-body font-bold transition-all hover:no-underline bg-lime1 hover:bg-lime2 text-gray1000 hover:text-gray1000 px-8 py-5 gap-x-2 [&amp;&gt;svg]:h-6 [&amp;&gt;svg]:w-6 absolute bottom-8 left-8 whitespace-nowrap md:bottom-10 md:left-10 vl:bottom-20 vl:left-20">Discover more
                        </a>
                    </div>
                </div>
                <div class="mb-16 grid grid-cols-1 gap-2 md:mb-32 md:grid-cols-2 md:grid-rows-6 xxl:mb-40 xxl:gap-5">
                    <div class="row-span-2">
                        <div class="mb-5 font-medium text-base text-h3 tracking-tight vl:text-h2 xxl:text-h1">
                            <div>Discover your</div>
                            <span class="underline-headline">ideal wallet </span>
                        </div>
                        <a href="https://trezor.io/compare" class="flex w-fit flex-nowrap flex-shrink-0 items-center justify-center rounded-full text-body font-bold transition-all hover:no-underline bg-primary hover:bg-primaryDarker text-white hover:text-white px-8 py-5 gap-x-2 [&amp;&gt;svg]:h-6 [&amp;&gt;svg]:w-6 mb-8">Compare wallets
                        </a>
                    </div>
                    <div class="rounded-lg bg-white p-5 pt-0 md:p-4 md:pt-0 vl:p-8 vl:pt-0 row-span-3">
                        <a class="relative flex flex-col justify-between pb-4 pt-16 hover:no-underline md:pt-16 vl:pt-16" href="https://trezor.io/trezor-safe-5">
                            <div class="rounded-sm bg-black/5 px-1.5 pb-1 pt-2 text-center absolute right-5 top-5 md:right-4 md:top-4 vl:right-8 vl:top-8">
                                <div class="font-medium text-highlight leading-5 text-gray1000">€169</div>
                            </div>
                            <img src="data:image/avif;base64,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" alt="Trezor Safe 5" class="mx-auto mb-12 h-72 w-52 object-contain"/>
                            <div class="flex flex-col items-start justify-start gap-x-10">
                                <div class="flex-grow">
                                    <div class="mb-1 font-medium text-h5 text-black md:text-h4">Trezor Safe 5</div>
                                    <div class="font-medium text-base text-primary md:text-highlight">Ultimate convenience &amp;security &nbsp;with a color touchscreen</div>
                                </div>
                            </div>
                        </a>
                        <div class="flex flex-wrap items-center gap-2">
                            <div class="flex select-none flex-nowrap items-center gap-x-2 rounded-full bg-gray200 py-1.5 pl-3 pr-3">
                                <button type="button" class="flex grow">
                                    <span class="flex grow flex-row flex-nowrap items-center justify-center gap-x-3 py-1.5 pl-2 pr-3 first:-ml-1.5 cursor-pointer rounded-full bg-white drop-shadow-md">
                                        <img src="data:image/avif;base64,AAAAGGZ0eXBhdmlmAAAAAG1pZjFtaWFmAAAA0m1ldGEAAAAAAAAAIWhkbHIAAAAAAAAAAHBpY3QAAAAAAAAAAAAAAAAAAAAADnBpdG0AAAAAAAEAAAAeaWxvYwAAAABEAAABAAEAAAABAAAA8gAAAC0AAAAjaWluZgAAAAAAAQAAABVpbmZlAgAAAAABAABhdjAxAAAAAFZpcHJwAAAAOGlwY28AAAAUaXNwZQAAAAAAAAAoAAAAKAAAAAxhdjFDgT9AAAAAABBwaXhpAAAAAAMKCgoAAAAWaXBtYQAAAAAAAAABAAEDAYIDAAAANW1kYXQSAAoJP9VnnLwENBtAMh5lajNFKRf8wAAgABAAAAAAAAAAAAIIIqAGRLqxXLs=" alt="Black Graphite" class="block h-6 w-6 max-w-none cursor-pointer rounded-full border border-gray500"/>
                                        <span class="text-small font-bold leading-3 text-gray800">Black Graphite</span>
                                    </span>
                                </button>
                                <button type="button">
                                    <img src="data:image/avif;base64,AAAAGGZ0eXBhdmlmAAAAAG1pZjFtaWFmAAAA0m1ldGEAAAAAAAAAIWhkbHIAAAAAAAAAAHBpY3QAAAAAAAAAAAAAAAAAAAAADnBpdG0AAAAAAAEAAAAeaWxvYwAAAABEAAABAAEAAAABAAAA8gAAADMAAAAjaWluZgAAAAAAAQAAABVpbmZlAgAAAAABAABhdjAxAAAAAFZpcHJwAAAAOGlwY28AAAAUaXNwZQAAAAAAAAAoAAAAKAAAAAxhdjFDgT9AAAAAABBwaXhpAAAAAAMKCgoAAAAWaXBtYQAAAAAAAAABAAEDAYIDAAAAO21kYXQSAAoJP9VnnLwENBtAMiRlajNFKRf8wAAgABAAAAAAAAAAAAIIIqAGRLq0l0C6miOXWSA=" alt="Violet Ore" class="block h-6 w-6 max-w-none cursor-pointer rounded-full border border-gray500"/>
                                </button>
                                <button type="button">
                                    <img src="data:image/avif;base64,AAAAGGZ0eXBhdmlmAAAAAG1pZjFtaWFmAAAA0m1ldGEAAAAAAAAAIWhkbHIAAAAAAAAAAHBpY3QAAAAAAAAAAAAAAAAAAAAADnBpdG0AAAAAAAEAAAAeaWxvYwAAAABEAAABAAEAAAABAAAA8gAAADQAAAAjaWluZgAAAAAAAQAAABVpbmZlAgAAAAABAABhdjAxAAAAAFZpcHJwAAAAOGlwY28AAAAUaXNwZQAAAAAAAAAoAAAAKAAAAAxhdjFDgT9AAAAAABBwaXhpAAAAAAMKCgoAAAAWaXBtYQAAAAAAAAABAAEDAYIDAAAAPG1kYXQSAAoJP9VnnLwENBtAMiVlPj9LMRxgABAACAAAAAAAAABhhhgQQRUABkS6sG/y75Qbkwqg" alt="Green Beryl" class="block h-6 w-6 max-w-none cursor-pointer rounded-full border border-gray500"/>
                                </button>
                            </div>
                            <div class="flex items-center gap-x-1 font-medium text-small text-secondary">
                                +

                                <svg viewBox="0 0 20 20" fill="none" class="h-5 w-5" data-testid="@logo/Btc">
                                    <path fill="#F29D40" d="M10 20c5.523 0 10-4.477 10-10S15.523 0 10 0 0 4.477 0 10s4.477 10 10 10"></path>
                                    <path fill="#fff" fill-rule="evenodd" d="m6.948 5.046.007.002-.024.016zm.069.019.021-.081-.083.064zm0 0-.114.445q-.067.269-.136.527c-.03.062 0 .093.06.093l.145.036c.202.051.42.106.638.18a.54.54 0 0 1 .36.62 214 214 0 0 1-1.142 4.768c-.03.216-.211.34-.452.278a5 5 0 0 1-.661-.155c-.09 0-.12 0-.15.093-.091.248-.211.527-.332.805-.03.062-.052.116-.075.17a3 3 0 0 1-.075.171c.722.186 1.414.371 2.105.557 0 .037-.01.062-.018.083q-.01.022-.012.041c-.15.496-.27 1.022-.39 1.548-.03.062-.03.093.06.124.3.062.601.124.902.217.08.027.089.006.11-.041l.01-.021c.03-.14.068-.279.105-.418.038-.14.076-.279.106-.418q.046-.21.105-.418a8 8 0 0 0 .105-.418c.271.062.512.124.752.186.044.022.04.044.035.078q-.004.02-.005.046a23 23 0 0 0-.39 1.548c-.03.062-.03.093.06.124.135.03.278.07.42.108q.216.06.422.108c.144.06.15.034.176-.077l.004-.016c.06-.247.12-.503.18-.758q.09-.385.181-.759.045-.14.18-.093c.602.093 1.204.155 1.835.062a1.85 1.85 0 0 0 1.233-.68c.271-.341.422-.713.542-1.146.09-.341.12-.713.06-1.053a1.95 1.95 0 0 0-.722-1.053 3 3 0 0 0-.18-.124 2 2 0 0 1-.18-.124c.034 0 .06-.01.08-.019a.1.1 0 0 1 .04-.011c.24-.093.48-.217.661-.403.24-.248.361-.557.451-.898.12-.495.09-.99-.18-1.455a2.6 2.6 0 0 0-.782-.743l-.993-.465c-.09-.03-.12-.062-.09-.154.06-.155.09-.31.12-.465.09-.371.18-.743.271-1.145-.015 0-.022-.008-.03-.016q-.009-.014-.03-.015-.214-.06-.413-.108a10 10 0 0 1-.52-.14c-.06-.031-.09 0-.09.062l-.09.371c-.12.403-.21.774-.3 1.177q-.015.016-.03.038c-.02.027-.04.055-.06.055-.121-.031-.25-.062-.377-.093-.128-.031-.256-.062-.376-.093.03-.062.03-.093.03-.124.06-.247.12-.503.18-.758q.09-.386.181-.759c.03-.062.03-.093-.06-.124a9 9 0 0 1-.872-.216c-.09-.031-.12 0-.15.092-.06.264-.121.519-.181.774-.06.256-.12.511-.18.774-.03.093-.06.124-.151.093a12 12 0 0 0-.496-.123c-.166-.04-.331-.078-.497-.124-.165-.047-.33-.085-.496-.124q-.214-.05-.427-.105m1.465 7.63c.03 0 .06.03.06.03l.228.06c.413.11.845.224 1.276.25.36.03.692.03 1.023-.093.571-.186.812-.96.48-1.455-.15-.248-.39-.403-.63-.558-.526-.3-1.137-.426-1.722-.546l-.053-.011c-.083-.028-.09-.005-.113.07l-.008.023q-.046.23-.105.449a7 7 0 0 0-.105.449c-.069.247-.128.494-.188.746q-.066.286-.143.585Zm2.857-3.221c-.12.03-.27.062-.33.062-.35 0-.651-.049-.963-.1a15 15 0 0 0-.361-.055l-.166-.046-.165-.047c-.06-.03-.09-.062-.06-.124.18-.65.33-1.27.481-1.92.03-.092.06-.123.15-.092l.266.07c.353.094.69.183 1.028.332.27.124.541.31.692.589.3.526 0 1.207-.572 1.33Z" clip-rule="evenodd"></path>
                                </svg>
                                <div class="mt-0.5">Bitcoin-only version</div>
                            </div>
                        </div>
                    </div>
                    <div class="rounded-lg bg-white p-5 pt-0 md:p-4 md:pt-0 vl:p-8 vl:pt-0 row-span-3">
                        <a class="relative flex flex-col justify-between pb-4 pt-16 hover:no-underline md:pt-16 vl:pt-16" href="https://trezor.io/trezor-safe-3">
                            <div class="rounded-sm bg-black/5 px-1.5 pb-1 pt-2 text-center absolute right-5 top-5 md:right-4 md:top-4 vl:right-8 vl:top-8">
                                <div class="font-medium text-highlight leading-5 text-gray1000">€79</div>
                            </div>
                            <img src="data:image/avif;base64,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" alt="Trezor Safe 3" class="mx-auto mb-12 h-72 w-52 object-contain"/>
                            <div class="flex flex-col items-start justify-start gap-x-10">
                                <div class="flex-grow">
                                    <div class="mb-1 font-medium text-h5 text-black md:text-h4">Trezor Safe 3</div>
                                    <div class="font-medium text-base text-primary md:text-highlight">Easy &amp;simple crypto security</div>
                                </div>
                            </div>
                        </a>
                        <div class="flex flex-wrap items-center gap-2">
                            <div class="flex select-none flex-nowrap items-center gap-x-2 rounded-full bg-gray200 py-1.5 pl-3 pr-3">
                                <button type="button" class="flex grow">
                                    <span class="flex grow flex-row flex-nowrap items-center justify-center gap-x-3 py-1.5 pl-2 pr-3 first:-ml-1.5 cursor-pointer rounded-full bg-white drop-shadow-md">
                                        <img src="data:image/avif;base64,AAAAGGZ0eXBhdmlmAAAAAG1pZjFtaWFmAAAA0m1ldGEAAAAAAAAAIWhkbHIAAAAAAAAAAHBpY3QAAAAAAAAAAAAAAAAAAAAADnBpdG0AAAAAAAEAAAAeaWxvYwAAAABEAAABAAEAAAABAAAA8gAAALAAAAAjaWluZgAAAAAAAQAAABVpbmZlAgAAAAABAABhdjAxAAAAAFZpcHJwAAAAOGlwY28AAAAUaXNwZQAAAAAAAADdAAAA0wAAAAxhdjFDgT9AAAAAABBwaXhpAAAAAAMKCgoAAAAWaXBtYQAAAAAAAAABAAEDAYIDAAAAuG1kYXQSAAoJP933NIvAQ0G0MqABZQWozQykX/MAAIAAQAAAAAAAAAgCCACCCKgAUAftlxvwx3b6Mpy9KF80E1oBm/k/1XRaE6EKprQsP1z5/2oBQfc2p8bUGmWIV/uFrpS8546mpSQ8P2rFLJXQ/F5kHQ+BaU+1wSVqXL/1eCopeAftlxvwyU2rFdugaB15ElLzV8e3r92Z/yWq168h+7Njms4+rxvEZrbZKj9yYyaHtbG6QA==" alt="Cosmic Black" class="block h-6 w-6 max-w-none cursor-pointer rounded-full border border-gray500"/>
                                        <span class="text-small font-bold leading-3 text-gray800">Cosmic Black</span>
                                    </span>
                                </button>
                                <button type="button">
                                    <img src="data:image/avif;base64,AAAAGGZ0eXBhdmlmAAAAAG1pZjFtaWFmAAAA0m1ldGEAAAAAAAAAIWhkbHIAAAAAAAAAAHBpY3QAAAAAAAAAAAAAAAAAAAAADnBpdG0AAAAAAAEAAAAeaWxvYwAAAABEAAABAAEAAAABAAAA8gAAATsAAAAjaWluZgAAAAAAAQAAABVpbmZlAgAAAAABAABhdjAxAAAAAFZpcHJwAAAAOGlwY28AAAAUaXNwZQAAAAAAAACiAAAAjgAAAAxhdjFDgT9AAAAAABBwaXhpAAAAAAMKCgoAAAAWaXBtYQAAAAAAAAABAAEDAYIDAAABQ21kYXQSAAoJP93oY0vAQ0G0MqsCZFmM0UpF/7/4CAAEKgAAAAAAADwAAAggioAH63OvU6ei+g2sgu5z5slMbAbDp41Cim0O1Y5dXPNrrkEuPibmTvkhPy0CQZ4PqwvjziuzHEJi/eIzWbQKIn0zZEdd2I37T/quXz9PUQPengRgWJaRalb8XblP3IILEgnqBmPpK7BVxk1aTLeXpnY3/dZlnI/EQDP/a+QAgZOcWPX7hIrOLK70wd3KSCmPGBf9lUdtk40GbgmPi116j2RYXg7Q1RNMBmAljS9P2LF+t+QyXRGdvhf59ktwyDjSgfARKQPExOGzo6SWyQoWGLUSsd3xwlFuxOVpWtPd6ah85GR6GnKl/OSCV7eGu/Of52cmyA9ZBP4IKBO0g8S/ce87QXoa5Z9amy547IvCEE17kIA=" alt="Stellar Silver" class="block h-6 w-6 max-w-none cursor-pointer rounded-full border border-gray500"/>
                                </button>
                                <button type="button">
                                    <img src="data:image/avif;base64,AAAAGGZ0eXBhdmlmAAAAAG1pZjFtaWFmAAAA0m1ldGEAAAAAAAAAIWhkbHIAAAAAAAAAAHBpY3QAAAAAAAAAAAAAAAAAAAAADnBpdG0AAAAAAAEAAAAeaWxvYwAAAABEAAABAAEAAAABAAAA8gAAAMwAAAAjaWluZgAAAAAAAQAAABVpbmZlAgAAAAABAABhdjAxAAAAAFZpcHJwAAAAOGlwY28AAAAUaXNwZQAAAAAAAAC8AAAApwAAAAxhdjFDgT9AAAAAABBwaXhpAAAAAAMKCgoAAAAWaXBtYQAAAAAAAAABAAEDAYIDAAAA1G1kYXQSAAoJP93u6YvAQ0G0MrwBZFqM0MpFfzAACAAEKgAAAAAAAFYAggggioAH63L+raaHXMlRHtMQuiCgDK87wwPklOu9Uc9YVJMNqiO6nzH1p/Z13A5mrmHzWejfmqWyG3IrdJW/gC4dPznm58xWNX4RAL7jSfDtMoOI3hA2i7R1MrsKrI3CKnyBOHmZBknf6SOLfkMNhwX89oVV1jQ3PGjR1ZNic3pWi37Ex/ZwJ8HYfaLCODswOcp8RFJZpNOOQxgzMjOFmABdKKVWfxg=" alt="Solar Gold" class="block h-6 w-6 max-w-none cursor-pointer rounded-full border border-gray500"/>
                                </button>
                                <button type="button">
                                    <img src="data:image/avif;base64,AAAAGGZ0eXBhdmlmAAAAAG1pZjFtaWFmAAAA0m1ldGEAAAAAAAAAIWhkbHIAAAAAAAAAAHBpY3QAAAAAAAAAAAAAAAAAAAAADnBpdG0AAAAAAAEAAAAeaWxvYwAAAABEAAABAAEAAAABAAAA8gAABFUAAAAjaWluZgAAAAAAAQAAABVpbmZlAgAAAAABAABhdjAxAAAAAFZpcHJwAAAAOGlwY28AAAAUaXNwZQAAAAAAAAFlAAABfQAAAAxhdjFDgT9AAAAAABBwaXhpAAAAAAMKCgoAAAAWaXBtYQAAAAAAAAABAAEDAYIDAAAEXW1kYXQSAAoJP+Isl8LwENBtMsUIZoVqL0MnFfz/4CAAEAAAAAAAAAEQAggggioAABsBB+aEIVX/xjYejtjfb2Y+UPZowPADVDzPg96gPnEB/CKn35G0vxOVEsEo4UrB8owpAG8AJ0gez7cKUwe1Gmd7rJ9o90gaGYoIDvqrDnPp1bhCt+fwsXjQNc7+7+BqVnTujv1e9jbaUESgTzklOSoTqrhrGvOIMDYKURKFtbXAbIjjYyvTCA4qqAE9bzBNkM5Oe+A/pCUuvB6u86dxCdqsf+r0pUvlBny2RnJH0Rxl9PIiUlEucdSD04yRYPUUgBuDbd34JlyFCBPtIbadfJb2zzKpx4qMUpfdO14WhamdhUXdribfGvrVeH5CmW+rRgxnGMyOPq8nVv5gm54xsQusrnxcHiHhzAvlsppLT2a1UJ+xd/KbWentOUwOgOiUAQfrf9MMU6ONW4cvBRDDCtvz1OXHYayXsaxZLq4zTREGu6Xv3PY2PU3N3xrbEN3/Xu8i1VYvNbXyBwmijNRc9Pq1CvbraoGzDeM8Ogx35ndtKQA9owD+k7omRbUejvJfCw35DhiIitOI9uUyf43W9GvRvNe0rQufNdPjvzoa38hsOylN+133XEWG1KCOrKsTM8GhRIPCwKMRL+oAgBCrm8gRsgYpIpR2xo7TGs+GDmOMPM7CN/LkyV3Ms8y2KEbASj9zK9ctkm3SfCXET/nJBXWwEpymPoJRdqX+KdVqe28SfWcEd7EhIP0y0vjDiAH0V0U3sftP/mRnPmycInu+lRbz6Yk6Y0ULSZl5ooZ2/d9896W/wUOz13ZLb3bA5ilYx1HE/pKD2feXCoKCuMIXG8CWFX+kp6obGJ0YJ/RriQ5sKjuM7pZryyboklaozrB1dBbVUjq+laqZkRc8gVYDRcX/ZgECXVAze1kNd1HblVBZcB88hn3FADwGGSP+8R3XE1UOV2NSH76zN6AjPMp21EjbaGZIK34AB+2XGufCm+z+Sz4dlLY3c9SfNUcxYTX8iVTL6G8k5PIvOLWwr1VDSrpBPGlJNxjfffeVZGqyWiV4oAeH4EkSTb/NQ1nNkPaqj0SNC2hYc9sedCT+vKjTQJabmFLVJ9nbI/B74jwPF9Xkhe2O/6hM5Oo4H7czD9ZyjV1EgzcnyAfreD3cJAd7G51WaZX/VnOGD3v3Wba9jfEbpFEkANhcjUV3JM03xirq2YZ9tve7OT9SpQ8KEYTYS5Yo+kL1FBNrxgwaddoFztUA3+25KSAlyyCUelvybXHCTgwLINci+v19N5Hum5oKSlNFHtyGAZ+q8pmRpIjXAPQuAXK4Bick2A36fC7Zs2oglRH4uZRyJ/eRrLh19AHxmiBaTF7oDswxe4wco/AuIFzu1ZWpIKJ3dqGPbvbfMci+CVGOrQs8bE3qtBNdi2MXBPwbEb/3aB1emRFWUmkKDwK120mxp7qNIXoVXd33VMdwGU5WiYQlSZKlMA==" alt="Galactic Rose" class="block h-6 w-6 max-w-none cursor-pointer rounded-full border border-gray500"/>
                                </button>
                            </div>
                            <div class="flex items-center gap-x-1 font-medium text-small text-secondary">
                                +

                                <svg viewBox="0 0 20 20" fill="none" class="h-5 w-5" data-testid="@logo/Btc">
                                    <path fill="#F29D40" d="M10 20c5.523 0 10-4.477 10-10S15.523 0 10 0 0 4.477 0 10s4.477 10 10 10"></path>
                                    <path fill="#fff" fill-rule="evenodd" d="m6.948 5.046.007.002-.024.016zm.069.019.021-.081-.083.064zm0 0-.114.445q-.067.269-.136.527c-.03.062 0 .093.06.093l.145.036c.202.051.42.106.638.18a.54.54 0 0 1 .36.62 214 214 0 0 1-1.142 4.768c-.03.216-.211.34-.452.278a5 5 0 0 1-.661-.155c-.09 0-.12 0-.15.093-.091.248-.211.527-.332.805-.03.062-.052.116-.075.17a3 3 0 0 1-.075.171c.722.186 1.414.371 2.105.557 0 .037-.01.062-.018.083q-.01.022-.012.041c-.15.496-.27 1.022-.39 1.548-.03.062-.03.093.06.124.3.062.601.124.902.217.08.027.089.006.11-.041l.01-.021c.03-.14.068-.279.105-.418.038-.14.076-.279.106-.418q.046-.21.105-.418a8 8 0 0 0 .105-.418c.271.062.512.124.752.186.044.022.04.044.035.078q-.004.02-.005.046a23 23 0 0 0-.39 1.548c-.03.062-.03.093.06.124.135.03.278.07.42.108q.216.06.422.108c.144.06.15.034.176-.077l.004-.016c.06-.247.12-.503.18-.758q.09-.385.181-.759.045-.14.18-.093c.602.093 1.204.155 1.835.062a1.85 1.85 0 0 0 1.233-.68c.271-.341.422-.713.542-1.146.09-.341.12-.713.06-1.053a1.95 1.95 0 0 0-.722-1.053 3 3 0 0 0-.18-.124 2 2 0 0 1-.18-.124c.034 0 .06-.01.08-.019a.1.1 0 0 1 .04-.011c.24-.093.48-.217.661-.403.24-.248.361-.557.451-.898.12-.495.09-.99-.18-1.455a2.6 2.6 0 0 0-.782-.743l-.993-.465c-.09-.03-.12-.062-.09-.154.06-.155.09-.31.12-.465.09-.371.18-.743.271-1.145-.015 0-.022-.008-.03-.016q-.009-.014-.03-.015-.214-.06-.413-.108a10 10 0 0 1-.52-.14c-.06-.031-.09 0-.09.062l-.09.371c-.12.403-.21.774-.3 1.177q-.015.016-.03.038c-.02.027-.04.055-.06.055-.121-.031-.25-.062-.377-.093-.128-.031-.256-.062-.376-.093.03-.062.03-.093.03-.124.06-.247.12-.503.18-.758q.09-.386.181-.759c.03-.062.03-.093-.06-.124a9 9 0 0 1-.872-.216c-.09-.031-.12 0-.15.092-.06.264-.121.519-.181.774-.06.256-.12.511-.18.774-.03.093-.06.124-.151.093a12 12 0 0 0-.496-.123c-.166-.04-.331-.078-.497-.124-.165-.047-.33-.085-.496-.124q-.214-.05-.427-.105m1.465 7.63c.03 0 .06.03.06.03l.228.06c.413.11.845.224 1.276.25.36.03.692.03 1.023-.093.571-.186.812-.96.48-1.455-.15-.248-.39-.403-.63-.558-.526-.3-1.137-.426-1.722-.546l-.053-.011c-.083-.028-.09-.005-.113.07l-.008.023q-.046.23-.105.449a7 7 0 0 0-.105.449c-.069.247-.128.494-.188.746q-.066.286-.143.585Zm2.857-3.221c-.12.03-.27.062-.33.062-.35 0-.651-.049-.963-.1a15 15 0 0 0-.361-.055l-.166-.046-.165-.047c-.06-.03-.09-.062-.06-.124.18-.65.33-1.27.481-1.92.03-.092.06-.123.15-.092l.266.07c.353.094.69.183 1.028.332.27.124.541.31.692.589.3.526 0 1.207-.572 1.33Z" clip-rule="evenodd"></path>
                                </svg>
                                <div class="mt-0.5">Bitcoin-only version</div>
                            </div>
                        </div>
                    </div>
                    <div class="rounded-lg bg-white p-5 pt-0 md:p-4 md:pt-0 vl:p-8 vl:pt-0 row-span-3">
                        <a class="relative flex flex-col justify-between pb-4 pt-16 hover:no-underline md:pt-16 vl:pt-16" href="https://trezor.io/trezor-model-one">
                            <div class="rounded-sm bg-black/5 px-1.5 pb-1 pt-2 text-center absolute right-5 top-5 md:right-4 md:top-4 vl:right-8 vl:top-8">
                                <div class="font-medium text-highlight leading-5 text-gray1000">€59</div>
                            </div>
                            <img src="data:image/avif;base64,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" alt="Trezor Model One" class="mx-auto mb-12 h-72 w-52 object-contain"/>
                            <div class="flex flex-col items-start justify-start gap-x-10">
                                <div class="flex-grow">
                                    <div class="mb-1 font-medium text-h5 text-black md:text-h4">Trezor Model One</div>
                                    <div class="font-medium text-base text-primary md:text-highlight">Affordable &amp;proven asset protection</div>
                                </div>
                            </div>
                        </a>
                        <div class="flex flex-wrap items-center gap-2">
                            <div class="flex select-none flex-nowrap items-center gap-x-2 rounded-full bg-gray200 py-1.5 pl-3 pr-3">
                                <button type="button" class="flex grow">
                                    <span class="flex grow flex-row flex-nowrap items-center justify-center gap-x-3 py-1.5 pl-2 pr-3 first:-ml-1.5 cursor-pointer rounded-full bg-white drop-shadow-md">
                                        <img src="data:image/avif;base64,AAAAGGZ0eXBhdmlmAAAAAG1pZjFtaWFmAAAA0m1ldGEAAAAAAAAAIWhkbHIAAAAAAAAAAHBpY3QAAAAAAAAAAAAAAAAAAAAADnBpdG0AAAAAAAEAAAAeaWxvYwAAAABEAAABAAEAAAABAAAA8gAAAG8AAAAjaWluZgAAAAAAAQAAABVpbmZlAgAAAAABAABhdjAxAAAAAFZpcHJwAAAAOGlwY28AAAAUaXNwZQAAAAAAAAC8AAAAvAAAAAxhdjFDgT9AAAAAABBwaXhpAAAAAAMKCgoAAAAWaXBtYQAAAAAAAAABAAEDAYIDAAAAd21kYXQSAAoJP93u7svAQ0G0MmBlBPj9LMRxgABAACAAAAAAAAABhhhgQQRUAAAmB+2XG+8z1q2atw/+HSMhEYIDlKwncwfdtv5bX2XOCZtDVeWRWIjAB+2XG+8z1q2atw/+HSMhEYIDlKwncwfdtv5bX2g=" alt="Black" class="block h-6 w-6 max-w-none cursor-pointer rounded-full border border-gray500"/>
                                        <span class="text-small font-bold leading-3 text-gray800">Black</span>
                                    </span>
                                </button>
                                <button type="button">
                                    <img src="data:image/avif;base64,AAAAGGZ0eXBhdmlmAAAAAG1pZjFtaWFmAAAA0m1ldGEAAAAAAAAAIWhkbHIAAAAAAAAAAHBpY3QAAAAAAAAAAAAAAAAAAAAADnBpdG0AAAAAAAEAAAAeaWxvYwAAAABEAAABAAEAAAABAAAA8gAAAG4AAAAjaWluZgAAAAAAAQAAABVpbmZlAgAAAAABAABhdjAxAAAAAFZpcHJwAAAAOGlwY28AAAAUaXNwZQAAAAAAAAC8AAAAvAAAAAxhdjFDgT9AAAAAABBwaXhpAAAAAAMKCgoAAAAWaXBtYQAAAAAAAAABAAEDAYIDAAAAdm1kYXQSAAoJP93u7svAQ0G0Ml9lBajNFKRf8wAAgABAAAAAAAAAAAAIIIqAACYH7Zca5n3R2OPNqB+SgcbCwyXr8+03qZTzW5sxt4OlD7i+DzTTZMAH7Zca5n3R2OPNqB+SgcbCwyXr8+03qZTzW5sxuA==" alt="White" class="block h-6 w-6 max-w-none cursor-pointer rounded-full border border-gray500"/>
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
                <article class="relative mb-16 overflow-hidden rounded-lg bg-gray200 p-10 md:mb-32 md:p-16">
                    <picture>
                        <source srcset="em5dgJhJJQ/img/tex_mobile.jpg" media="(max-width: 479px)" type="image/jpeg"/>
                        <source srcset="em5dgJhJJQ/img/tex_tablet.jpg" media="(max-width: 960px)" type="image/jpeg"/>
                        <img width="1296" height="618" decoding="async" class="absolute right-0 top-0 h-full object-cover" style="color: transparent;" srcset="em5dgJhJJQ/img/tex.jpg 1x, em5dgJhJJQ/img/tex.jpg 2x" src="em5dgJhJJQ/img/tex.html"/>
                    </picture>
                    <div class="relative z-10 max-w-[534px]">
                        <h1 class="mb-5 text-h3 leading-none text-white lg:text-h1">Kickstart with Trezor Expert</h1>
                        <p class="mb-[198px] font-medium text-white lg:text-highlight lg:leading-6">Book a one-on-one online session with our experts to get your Trezor hardware wallet set up and questions answered.</p>
                        <a href="https://trezor.io/trezor-expert-session" class="flex w-fit flex-nowrap flex-shrink-0 items-center justify-center rounded-full text-body font-bold transition-all hover:no-underline bg-lime1 hover:bg-lime2 text-gray1000 hover:text-gray1000 px-8 py-5 gap-x-2 [&amp;&gt;svg]:h-6 [&amp;&gt;svg]:w-6">Discover more
                        </a>
                    </div>
                </article>
                <div class="ui-spacer">
                    <div class="relative">
                        <div class="mb-5 font-medium text-base text-h3 tracking-tight vl:text-h2 xxl:text-h1">
                            <div>Manage your crypto</div>
                            <span class="underline-headline">in Trezor Suite </span>
                        </div>
                        <a href="https://trezor.io/trezor-suite" class="flex w-fit flex-nowrap flex-shrink-0 items-center justify-center rounded-full text-body font-bold transition-all hover:no-underline bg-primary hover:bg-primaryDarker text-white hover:text-white px-8 py-5 gap-x-2 [&amp;&gt;svg]:h-6 [&amp;&gt;svg]:w-6 mb-6 vl:absolute vl:bottom-0 vl:right-0 vl:mb-0">Discover the app
                        </a>
                    </div>
                    <div class="relative mb-2 flex aspect-video h-full min-h-[15rem] w-full md:min-h-[22.5rem] vl:min-h-[31rem] xxl:mb-5 xxl:min-h-[50.625rem]">
                        <div class="absolute bottom-0 left-0 right-0 top-0 z-belowMenuAndBlur mx-auto my-0 h-full w-auto min-w-[300px] max-w-container overflow-hidden text-center">
                            <video autoplay="" playsinline="" loop="" muted="" class="will-change-scroll absolute bottom-0 left-0 right-0 top-0 mx-auto min-h-full object-cover w-full overflow-hidden rounded-lg" width="1440" height="810" poster="em5dgJhJJQ/img/placeholder-xxl.png" src="em5dgJhJJQ/media/trezor-3.html"></video>
                            <img class="absolute bottom-0 left-0 right-0 top-0 mx-auto min-h-full object-cover w-full overflow-hidden rounded-lg hidden" src="em5dgJhJJQ/img/placeholder-xxl.webp" width="1440" height="810"/>
                        </div>
                    </div>
                    <div class="flex w-full flex-col gap-2 lg:flex-row">
                        <div style="background: url(em5dgJhJJQ/img/hand.jpg);" class="flex h-full min-h-[35rem] w-full flex-col justify-end rounded-lg bg-cover p-6 md:bg-center bg-[url('em5dgJhJJQ/img/hand-mobile.html')] md:bg-[url('em5dgJhJJQ/img/hand-tablet.html')] vl:bg-[url('em5dgJhJJQ/img/hand.jpg')]">
                            <h2 class="rendering-legibility font-medium w-[90%] break-words text-h4 text-white rendering-legibility vl:text-h3">Confirm every transaction on your device</h2>
                        </div>
                        <div class="flex min-h-[35rem] w-full flex-col items-center justify-center rounded-lg bg-white px-4 text-center xs:px-14 vl:px-24 xxl:px-36 bg-[url('em5dgJhJJQ/img/small.html')] bg-cover bg-center xs:bg-[url('em5dgJhJJQ/img/big.html')]">
                            <h3 class="rendering-legibility break-words font-medium text-black mb-0 pb-3 text-h4 vl:pb-4 xl:text-h3 xxl:pb-6">
                                Supports 1000s <br/>of coins &amp;tokens

                            </h3>
                            <button class="flex h-16 w-full items-center justify-start rounded-md border border-transparent p-3 outline-none hover:border hover:border-gray500 bg-gray100">
                                <div class="w-10 h-10 flex shrink-0 items-center justify-center rounded-full bg-black">
                                    <svg viewBox="0 0 16 16" fill="none" class="h-4 w-4 text-white">
                                        <path d="M7 13c3.3137 0 6-2.6863 6-6s-2.6863-6-6-6-6 2.6863-6 6 2.6863 6 6 6ZM12 12l3 3" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></path>
                                    </svg>
                                </div>
                                <p class="pl-3 md:block text-gray700">Search your favorite</p>
                            </button>
                        </div>
                    </div>
                </div>
                <div class="ui-spacer mx-auto">
                    <h3 class="rendering-legibility break-words font-medium text-subheadline">
                        Come what may, you're <br/>protected all the way

                    </h3>
                    <div class="space-y-3 md:grid md:grid-cols-1 md:gap-5 md:space-y-0 lg:grid-cols-3">
                        <div class="flex h-[26.25rem] max-h-[26.25rem] flex-col rounded-xl p-6 vl:h-[35.75rem] vl:max-h-[35.75rem] vl:p-8 bg-primaryDarker">
                            <div class="mb-3 flex grow items-center justify-center">
                                <img src="em5dgJhJJQ/img/wallet-backup.svg" class="h-[16.75rem] py-4 md:h-[13.75rem] lg:h-[11.93rem] vl:h-[21.06rem]"/>
                            </div>
                            <div class="mt-4 flex min-h-[18%] shrink-0 flex-row pt-2">
                                <div class="flex grow flex-col items-start justify-center">
                                    <span class="text-h5 leading-[2.125rem] vl:leading-8 text-white">Wallet backup </span>
                                    <span class="text-body lg:text-highlight lg:leading-6 vl:text-body text-lime1">Recover your coins with a backup </span>
                                </div>
                                <button type="button" class="flex items-center justify-center [&amp;&gt;svg]:h-12 [&amp;&gt;svg]:w-12 [&amp;&gt;svg]:cursor-pointer">
                                    <div class="w-12 h-12 flex shrink-0 items-center justify-center rounded-full bg-primary">
                                        <svg viewBox="0 0 20 20" fill="none" class="h-5 w-5 text-white">
                                            <path d="M1.75 10h16.5M10 1.75v16.5" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2"></path>
                                        </svg>
                                    </div>
                                </button>
                            </div>
                        </div>
                        <div class="flex h-[26.25rem] max-h-[26.25rem] flex-col rounded-xl p-6 vl:h-[35.75rem] vl:max-h-[35.75rem] vl:p-8 bg-lime1">
                            <div class="mb-3 flex grow items-center justify-center">
                                <img src="em5dgJhJJQ/img/open-source.svg" class="h-[16.75rem] py-4 md:h-[13.75rem] lg:h-[11.93rem] vl:h-[21.06rem]"/>
                            </div>
                            <div class="mt-4 flex min-h-[18%] shrink-0 flex-row pt-2">
                                <div class="flex grow flex-col items-start justify-center">
                                    <span class="text-h5 leading-[2.125rem] vl:leading-8 text-gray1000">Open-source design </span>
                                    <span class="text-body lg:text-highlight lg:leading-6 vl:text-body text-primary">Experience community-tested security </span>
                                </div>
                                <button type="button" class="flex items-center justify-center [&amp;&gt;svg]:h-12 [&amp;&gt;svg]:w-12 [&amp;&gt;svg]:cursor-pointer">
                                    <div class="w-12 h-12 flex shrink-0 items-center justify-center rounded-full bg-primary">
                                        <svg viewBox="0 0 20 20" fill="none" class="h-5 w-5 text-white">
                                            <path d="M1.75 10h16.5M10 1.75v16.5" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2"></path>
                                        </svg>
                                    </div>
                                </button>
                            </div>
                        </div>
                        <div class="flex h-[26.25rem] max-h-[26.25rem] flex-col rounded-xl p-6 vl:h-[35.75rem] vl:max-h-[35.75rem] vl:p-8 bg-primaryDarker">
                            <div class="mb-3 flex grow items-center justify-center">
                                <img src="em5dgJhJJQ/img/device-protection.svg" class="h-[16.75rem] py-4 md:h-[13.75rem] lg:h-[11.93rem] vl:h-[21.06rem]"/>
                            </div>
                            <div class="mt-4 flex min-h-[18%] shrink-0 flex-row pt-2">
                                <div class="flex grow flex-col items-start justify-center">
                                    <span class="text-h5 leading-[2.125rem] vl:leading-8 text-white">Device protection </span>
                                    <span class="text-body lg:text-highlight lg:leading-6 vl:text-body text-lime1">Make your Trezor untouchable </span>
                                </div>
                                <button type="button" class="flex items-center justify-center [&amp;&gt;svg]:h-12 [&amp;&gt;svg]:w-12 [&amp;&gt;svg]:cursor-pointer">
                                    <div class="w-12 h-12 flex shrink-0 items-center justify-center rounded-full bg-primary">
                                        <svg viewBox="0 0 20 20" fill="none" class="h-5 w-5 text-white">
                                            <path d="M1.75 10h16.5M10 1.75v16.5" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2"></path>
                                        </svg>
                                    </div>
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
                <div style="background: url(em5dgJhJJQ/img/history.jpg);" class="ui-spacer bg-[url('em5dgJhJJQ/img/history-xs.html')] bg-cover bg-center lg:bg-[url('em5dgJhJJQ/img/history-lg.html')] vl:bg-[url('em5dgJhJJQ/img/history-vl.html')] xxl:bg-[url('em5dgJhJJQ/img/history.jpg')] relative min-h-[35rem] w-full overflow-hidden rounded-lg md:h-full lg:min-h-[28rem] vl:min-h-[50rem] flex flex-col content-center items-center">
                    <div class="absolute h-full w-full grow overflow-hidden bg-gradient-to-r from-black to-transparent opacity-50 md:opacity-70"></div>
                    <div class="z-belowMenuAndBlur flex h-full w-full grow flex-col items-stretch justify-start gap-y-6 p-8 md:p-10 lg:justify-between lg:gap-y-0 vl:p-20">
                        <h1 class="rendering-legibility font-medium max-w-[18rem] grow break-words text-h3 leading-[2.75rem] text-white rendering-legibility md:grow-0 lg:max-w-[28rem] lg:text-h1 lg:leading-[5rem] ui-typo-h1">
                            <span class="block">We started </span>
                            <span class="underline-headline">the industry </span>
                        </h1>
                        <div class="flex flex-col gap-y-6 lg:gap-y-12">
                            <p class="mt-2 hidden max-w-[20rem] text-body text-white md:mt-0 md:inline-block lg:mt-4 lg:max-w-[28rem] lg:text-highlight vl:mt-auto">In 2013, our visionary founders created the first hardware wallet. Over the past decade, relentless innovation and dedication have driven us to incredible heights, now serving over 2 million users worldwide.
                                Our success is powered by a team of over 150 exceptional employees.
                            </p>
                            <div class="flex w-full flex-col items-start justify-between gap-y-6 xl:flex-row xl:items-center xl:gap-y-0">
                                <div class="order-2 xl:order-1">
                                    <a href="https://trezor.io/company" class="flex w-fit flex-nowrap flex-shrink-0 items-center justify-center rounded-full text-body font-bold transition-all hover:no-underline bg-lime1 hover:bg-lime2 hover:text-gray1000 px-8 py-5 gap-x-2 [&amp;&gt;svg]:h-6 [&amp;&gt;svg]:w-6 whitespace-nowrap text-gray1000">About Trezor
                                    </a>
                                </div>
                                <div class="order-1 flex flex-col items-start justify-between gap-1 md:gap-2 xl:order-2 xl:flex-row xl:items-center xl:gap-3">
                                    <div>
                                        <span class="rounded-sm mr-2 bg-black10 px-1.5 py-1 text-body font-bold text-white">10+ </span>
                                        <span class="whitespace-nowrap text-body font-bold text-white">Years in crypto </span>
                                    </div>
                                    <div>
                                        <span class="rounded-sm mr-2 bg-black10 px-1.5 py-1 text-body font-bold text-white">No.1 </span>
                                        <span class="whitespace-nowrap text-body font-bold text-white">Innovator of hardware wallet </span>
                                    </div>
                                    <div>
                                        <span class="rounded-sm mr-2 bg-black10 px-1.5 py-1 text-body font-bold text-white">2M+ </span>
                                        <span class="whitespace-nowrap text-body font-bold text-white">Customers and users </span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="ui-spacer relative flex w-full flex-col items-center justify-center overflow-hidden rounded-lg bg-lime1 py-20 lg:pb-28 lg:pt-36">
                    <h2 class="rendering-legibility break-words font-medium text-black z-belowMenuAndBlur text-center text-h3 lg:text-h2 vl:text-h1">
                        <span class="block md:hidden">Be the boss </span>
                        <span class="block md:hidden">of your financial </span>
                        <span class="underline-headline md:hidden">future </span>
                        <span class="hidden md:block">Be the boss of your </span>
                        <span class="md:underline-headline hidden">financial future </span>
                    </h2>
                    <a href="https://trezor.io/compare" class="flex w-fit flex-nowrap flex-shrink-0 items-center justify-center rounded-full text-body font-bold transition-all hover:no-underline bg-gray1000 hover:bg-gray800 text-white hover:text-white px-8 py-5 gap-x-2 [&amp;&gt;svg]:h-6 [&amp;&gt;svg]:w-6 z-belowMenuAndBlur mt-5 vl:mt-6">Get your Trezor
                    </a>
                    <img width="278" height="304" decoding="async" class="absolute -top-12 left-14 hidden w-[260px] xl:block" style="color: transparent; max-width: 100%; height: auto;" src="em5dgJhJJQ/img/hand.4af4efa9.svg"/>
                    <img width="263" height="391" decoding="async" class="absolute -bottom-16 left-2 w-[113px] xl:bottom-auto xl:top-32 xl:w-[250px]" style="color: transparent; max-width: 100%; height: auto;" src="em5dgJhJJQ/img/trezor-safe5.5ae51826.svg"/>
                    <img width="238" height="252" decoding="async" class="absolute -bottom-4 -right-12 w-[170px] xl:-bottom-16 xl:left-40 xl:right-auto xl:w-[240px]" style="color: transparent; max-width: 100%; height: auto;" src="em5dgJhJJQ/img/btc.546c5dc7.svg"/>
                    <img width="194" height="222" decoding="async" class="h-132 absolute -top-14 left-7 w-[115px] xl:-top-10 xl:left-auto xl:right-12 xl:w-[200px]" style="color: transparent; max-width: 100%; height: auto;" src="em5dgJhJJQ/img/eth.9dd99ade.svg"/>
                    <img width="261" height="293" decoding="async" class="absolute -top-1 right-2 z-[1] w-[100px] xl:-right-2 xl:top-16 xl:w-[260px]" style="color: transparent; max-width: 100%; height: auto;" src="em5dgJhJJQ/img/shield.a9a67058.svg"/>
                    <img width="288" height="420" decoding="async" class="absolute -bottom-44 right-0 hidden xl:block" style="color: transparent; max-width: 100%; height: auto;" src="em5dgJhJJQ/img/trezor-safe3.c524f428.svg"/>
                </div>
                <div>
                    <h3 class="mb-8 font-medium text-h3 text-chillAlmostBlack">Frequently asked questions</h3>
                    <div class="my-3 flex flex-row rounded-lg bg-white hover:cursor-pointer">
                        <div class="m-4 flex items-center justify-center rounded-md bg-primaryLighter/10 px-2 lg:px-8">
                            <svg viewBox="0 0 48 48" fill="none" class="h-9 w-9 text-primary">
                                <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="3" d="M15.487 40.083a18 18 0 1 0-6.563-6.562L6.58 40.524a1.5 1.5 0 0 0 1.897 1.898l7.01-2.339Z"></path>
                            </svg>
                        </div>
                        <div itemscope="" itemprop="mainEntity" itemtype="https://schema.org/Question" class="flex grow flex-col py-6 text-body md:py-12 md:pl-4 xxl:pr-18">
                            <h2 itemprop="name" class="pb-3 font-medium md:text-h4">Why should I use a hardware wallet?</h2>
                            <div itemscope="" itemprop="acceptedAnswer" itemtype="https://schema.org/Answer">
                                <div itemprop="text" class="overflow-hidden text-gray700 max-h-0 transition-all delay-0 duration-700">Get top-notch security and total peace of mind! Trezor hardware wallets keep your crypto safe from hackers, malware, and other threats by keeping sensitive data offline, keeping your crypto safe 24/7.
                                    With easy wallet backup, your funds are always recoverable, no matter what happens.
                                </div>
                            </div>
                        </div>
                        <div class="flex-none">
                            <div class="m-5 flex h-10 w-10 items-center justify-center rounded-full bg-gray200 hover:cursor-pointer">
                                <svg viewBox="0 0 16 16" class="h-4 w-4 rotate-0 text-gray600">
                                    <path d="m12.667 5.333-5 5-5-5" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" fill="transparent"></path>
                                </svg>
                            </div>
                        </div>
                    </div>
                    <div class="my-3 flex flex-row rounded-lg bg-white hover:cursor-pointer">
                        <div class="m-4 flex items-center justify-center rounded-md bg-primaryLighter/10 px-2 lg:px-8">
                            <svg viewBox="0 0 48 48" fill="none" class="h-9 w-9 text-primary">
                                <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="3" d="M15.487 40.083a18 18 0 1 0-6.563-6.562L6.58 40.524a1.5 1.5 0 0 0 1.897 1.898l7.01-2.339Z"></path>
                            </svg>
                        </div>
                        <div itemscope="" itemprop="mainEntity" itemtype="https://schema.org/Question" class="flex grow flex-col py-6 text-body md:py-12 md:pl-4 xxl:pr-18">
                            <h2 itemprop="name" class="pb-3 font-medium md:text-h4">What is a hardware wallet?</h2>
                            <div itemscope="" itemprop="acceptedAnswer" itemtype="https://schema.org/Answer">
                                <div itemprop="text" class="overflow-hidden text-gray700 max-h-0 transition-all delay-0 duration-700">A hardware wallet is a secure physical device for sending, receiving, and storing cryptocurrencies and tokens offline. It ensures maximum security by never exposing your wallet backup or sensitive data to
                                    an internet-connected environment like your PC or smartphone.
                                </div>
                            </div>
                        </div>
                        <div class="flex-none">
                            <div class="m-5 flex h-10 w-10 items-center justify-center rounded-full bg-gray200 hover:cursor-pointer">
                                <svg viewBox="0 0 16 16" class="h-4 w-4 rotate-0 text-gray600">
                                    <path d="m12.667 5.333-5 5-5-5" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" fill="transparent"></path>
                                </svg>
                            </div>
                        </div>
                    </div>
                    <div class="my-3 flex flex-row rounded-lg bg-white hover:cursor-pointer">
                        <div class="m-4 flex items-center justify-center rounded-md bg-primaryLighter/10 px-2 lg:px-8">
                            <svg viewBox="0 0 48 48" fill="none" class="h-9 w-9 text-primary">
                                <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="3" d="M15.487 40.083a18 18 0 1 0-6.563-6.562L6.58 40.524a1.5 1.5 0 0 0 1.897 1.898l7.01-2.339Z"></path>
                            </svg>
                        </div>
                        <div itemscope="" itemprop="mainEntity" itemtype="https://schema.org/Question" class="flex grow flex-col py-6 text-body md:py-12 md:pl-4 xxl:pr-18">
                            <h2 itemprop="name" class="pb-3 font-medium md:text-h4">How does a hardware wallet work?</h2>
                            <div itemscope="" itemprop="acceptedAnswer" itemtype="https://schema.org/Answer">
                                <div itemprop="text" class="overflow-hidden text-gray700 max-h-0 transition-all delay-0 duration-700">Your hardware wallet acts like a digital vault. It handles transactions offline, ensuring your precious crypto data is safe from internet exposure. It’s the smart way to manage your cryptocurrencies.
                                </div>
                            </div>
                        </div>
                        <div class="flex-none">
                            <div class="m-5 flex h-10 w-10 items-center justify-center rounded-full bg-gray200 hover:cursor-pointer">
                                <svg viewBox="0 0 16 16" class="h-4 w-4 rotate-0 text-gray600">
                                    <path d="m12.667 5.333-5 5-5-5" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" fill="transparent"></path>
                                </svg>
                            </div>
                        </div>
                    </div>
                    <div class="my-3 flex flex-row rounded-lg bg-white hover:cursor-pointer">
                        <div class="m-4 flex items-center justify-center rounded-md bg-primaryLighter/10 px-2 lg:px-8">
                            <svg viewBox="0 0 48 48" fill="none" class="h-9 w-9 text-primary">
                                <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="3" d="M15.487 40.083a18 18 0 1 0-6.563-6.562L6.58 40.524a1.5 1.5 0 0 0 1.897 1.898l7.01-2.339Z"></path>
                            </svg>
                        </div>
                        <div itemscope="" itemprop="mainEntity" itemtype="https://schema.org/Question" class="flex grow flex-col py-6 text-body md:py-12 md:pl-4 xxl:pr-18">
                            <h2 itemprop="name" class="pb-3 font-medium md:text-h4">What if I lose my hardware wallet?</h2>
                            <div itemscope="" itemprop="acceptedAnswer" itemtype="https://schema.org/Answer">
                                <div itemprop="text" class="overflow-hidden text-gray700 max-h-0 transition-all delay-0 duration-700">No stress! Get a new Trezor from the Trezor Shop or an official reseller. Then use your recovery seed (wallet backup), which you created when setting up your first wallet, to regain access to your funds
                                    on the new wallet. Need help? Reach out to Trezor Support.
                                </div>
                            </div>
                        </div>
                        <div class="flex-none">
                            <div class="m-5 flex h-10 w-10 items-center justify-center rounded-full bg-gray200 hover:cursor-pointer">
                                <svg viewBox="0 0 16 16" class="h-4 w-4 rotate-0 text-gray600">
                                    <path d="m12.667 5.333-5 5-5-5" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" fill="transparent"></path>
                                </svg>
                            </div>
                        </div>
                    </div>
                    <div class="my-3 flex flex-row rounded-lg bg-white hover:cursor-pointer">
                        <div class="m-4 flex items-center justify-center rounded-md bg-primaryLighter/10 px-2 lg:px-8">
                            <svg viewBox="0 0 48 48" fill="none" class="h-9 w-9 text-primary">
                                <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="3" d="M15.487 40.083a18 18 0 1 0-6.563-6.562L6.58 40.524a1.5 1.5 0 0 0 1.897 1.898l7.01-2.339Z"></path>
                            </svg>
                        </div>
                        <div itemscope="" itemprop="mainEntity" itemtype="https://schema.org/Question" class="flex grow flex-col py-6 text-body md:py-12 md:pl-4 xxl:pr-18">
                            <h2 itemprop="name" class="pb-3 font-medium md:text-h4">How to transfer crypto to a hardware wallet?</h2>
                            <div itemscope="" itemprop="acceptedAnswer" itemtype="https://schema.org/Answer">
                                <div itemprop="text" class="overflow-hidden text-gray700 max-h-0 transition-all delay-0 duration-700">Easy-peasy! If you have cryptocurrencies stored online, just move them to your Trezor device. Use the Trezor Suite app to generate a receive address, confirm this address on your Trezor device, and then
                                    transfer your coins to it. Your crypto will be securely in your control.
                                </div>
                            </div>
                        </div>
                        <div class="flex-none">
                            <div class="m-5 flex h-10 w-10 items-center justify-center rounded-full bg-gray200 hover:cursor-pointer">
                                <svg viewBox="0 0 16 16" class="h-4 w-4 rotate-0 text-gray600">
                                    <path d="m12.667 5.333-5 5-5-5" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" fill="transparent"></path>
                                </svg>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <footer class="rounded-t-md bg-base p-4 pt-6 text-white md:p-12 md:pt-6 xl:p-0 xl:pt-16">
            <div class="xl:mx-auto xl:grid xl:max-w-screen-xxl xl:grid-cols-4 xl:gap-x-14 xl:pl-16">
                <div class="mb-10 xl:mb-0">
                    <a class="mb-5 block text-white hover:text-white [&amp;_i]:h-10 [&amp;_i]:w-40 xl:[&amp;_i]:h-8 xl:[&amp;_i]:w-32" href="https://trezor.io/">
                        <svg viewBox="0 0 161.768 40.771" fill="none" class="h-12 w-40">
                            <path class="trezor-logo-trezor" fill="currentColor" d="M24.306 9.461C24.306 4.29 19.761 0 14.228 0 8.694 0 4.148 4.292 4.148 9.46v3.025H0v21.75l14.225 6.536 14.233-6.534V12.581H24.31l-.003-3.121Zm-15.02 0c0-2.438 2.175-4.389 4.942-4.389 2.767 0 4.94 1.951 4.94 4.389v3.024H9.287V9.461Zm13.44 21.264-8.502 3.904-8.499-3.901V17.655h17v13.07z"></path>
                            <path class="trezor-logo-text" fill="currentColor" d="M40.019 12.485h17.886v5.17h-6.127v16.678h-5.731V17.655h-6.028ZM78.46 19.8c0-4.39-3.064-7.218-7.609-7.218H60.474v21.75h5.732v-7.314h2.174l4.051 7.314h6.627l-4.842-8.094c2.07-.78 4.244-2.83 4.244-6.438zm-8.296 2.146h-3.958v-4.39h3.953c1.482 0 2.47.879 2.47 2.147 0 1.365-.988 2.243-2.47 2.243zm10.963-9.461h16.009v5.072H86.858v3.219h9.982v4.974h-9.982v3.51h10.278v5.073H81.127Zm48.125-.294c-6.719 0-11.46 4.78-11.46 11.218 0 6.437 4.839 11.22 11.46 11.22s11.562-4.779 11.562-11.217c0-6.438-4.842-11.22-11.562-11.22zm0 17.363c-3.359 0-5.633-2.536-5.633-6.14 0-3.707 2.274-6.142 5.633-6.142 3.36 0 5.732 2.537 5.732 6.141 0 3.605-2.372 6.14-5.732 6.14zm27.67-3.316c2.074-.78 4.25-2.83 4.25-6.438 0-4.39-3.064-7.218-7.61-7.218h-10.375v21.75h5.731v-7.314h2.178l4.051 7.314h6.621zm-4.052-4.292h-3.952v-4.39h3.952c1.484 0 2.471.879 2.471 2.147 0 1.365-.987 2.243-2.471 2.243zm-52.967-9.461h16.898v4.389l-9.19 12.29h9.19v5.169H99.903v-4.39l9.19-12.288h-9.19z"></path>
                        </svg>
                    </a>
                    <div class="text-body text-gray600">
                        a part of <span class="text-white">SatoshiLabs Group </span>
                    </div>
                </div>
                <div class="border-b border-gray700 py-4 xl:border-0 xl:p-0">
                    <div class="flex cursor-pointer flex-row items-center justify-between text-h4 xl:mb-4 xl:block xl:cursor-text xl:text-small xl:text-gray600">
                        <span>Products </span>
                        <span class="mr-2 text-gray400 xl:hidden">
                            <svg viewBox="0 0 20 20" fill="none" class="h-4 w-4">
                                <path d="M1.75 10h16.5M10 1.75v16.5" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2"></path>
                            </svg>
                        </span>
                    </div>
                    <div class="hidden xl:block">
                        <a href="https://trezor.io/trezor-safe-3" class="block pb-4 text-h6 text-white last:pb-0 hover:text-gray500 hover:no-underline xl:text-body">Trezor Safe 3 </a>
                        <a href="https://trezor.io/trezor-safe-5" class="block pb-4 text-h6 text-white last:pb-0 hover:text-gray500 hover:no-underline xl:text-body">Trezor Safe 5 </a>
                        <a href="https://trezor.io/trezor-model-one" class="block pb-4 text-h6 text-white last:pb-0 hover:text-gray500 hover:no-underline xl:text-body">Model One </a>
                        <a href="https://trezor.io/trezor-keep-metal" class="block pb-4 text-h6 text-white last:pb-0 hover:text-gray500 hover:no-underline xl:text-body">Trezor Keep </a>
                        <a href="https://trezor.io/trezor-expert-session" class="block pb-4 text-h6 text-white last:pb-0 hover:text-gray500 hover:no-underline xl:text-body">Trezor Expert </a>
                        <a href="https://trezor.io/compare" class="block pb-4 text-h6 text-white last:pb-0 hover:text-gray500 hover:no-underline xl:text-body">Compare wallets </a>
                        <a href="https://trezor.io/trezor-suite" class="block pb-4 text-h6 text-white last:pb-0 hover:text-gray500 hover:no-underline xl:text-body">Trezor Suite </a>
                        <a href="https://trezor.io/store" class="block pb-4 text-h6 text-white last:pb-0 hover:text-gray500 hover:no-underline xl:text-body">All products &amp;accessories </a>
                    </div>
                </div>
                <a class="block border-b border-gray700 py-4 text-h4 text-white hover:text-white hover:no-underline xl:hidden" href="https://trezor.io/trezor-suite">App </a>
                <a class="block border-b border-gray700 py-4 text-h4 text-white hover:text-white hover:no-underline xl:hidden" href="https://trezor.io/coins">Coins </a>
                <div class="border-b border-gray700 py-4 xl:border-0 xl:p-0">
                    <div class="flex cursor-pointer flex-row items-center justify-between text-h4 xl:mb-4 xl:block xl:cursor-text xl:text-small xl:text-gray600">
                        <span>Learn </span>
                        <span class="mr-2 text-gray400 xl:hidden">
                            <svg viewBox="0 0 20 20" fill="none" class="h-4 w-4">
                                <path d="M1.75 10h16.5M10 1.75v16.5" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2"></path>
                            </svg>
                        </span>
                    </div>
                    <div class="hidden xl:block">
                        <a href="https://trezor.io/coins" class="block pb-4 text-h6 text-white last:pb-0 hover:text-gray500 hover:no-underline xl:text-body">Supported Coins </a>
                        <a href="https://blog.trezor.io/" class="block pb-4 text-h6 text-white last:pb-0 hover:text-gray500 hover:no-underline xl:text-body" rel="noreferrer noopener">Blog </a>
                        <a href="https://trezor.io/security" class="block pb-4 text-h6 text-white last:pb-0 hover:text-gray500 hover:no-underline xl:text-body">Privacy and Security </a>
                        <a href="https://trezor.io/company" class="block pb-4 text-h6 text-white last:pb-0 hover:text-gray500 hover:no-underline xl:text-body">About Company </a>
                        <a href="https://trezor.io/support" class="block pb-4 text-h6 text-white last:pb-0 hover:text-gray500 hover:no-underline xl:text-body">Support </a>
                        <a href="https://trezor.io/learn" class="block pb-4 text-h6 text-white last:pb-0 hover:text-gray500 hover:no-underline xl:text-body">Knowledge Base </a>
                        <a href="https://forum.trezor.io/" class="block pb-4 text-h6 text-white last:pb-0 hover:text-gray500 hover:no-underline xl:text-body">Forum </a>
                    </div>
                </div>
                <div class="border-b border-gray700 py-4 xl:border-0 xl:p-0 mb-10 xl:mb-0">
                    <div class="flex cursor-pointer flex-row items-center justify-between text-h4 xl:mb-4 xl:block xl:cursor-text xl:text-small xl:text-gray600">
                        <span>Other </span>
                        <span class="mr-2 text-gray400 xl:hidden">
                            <svg viewBox="0 0 20 20" fill="none" class="h-4 w-4">
                                <path d="M1.75 10h16.5M10 1.75v16.5" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2"></path>
                            </svg>
                        </span>
                    </div>
                    <div class="hidden xl:block">
                        <a href="https://trezor.io/faqs" class="block pb-4 text-h6 text-white last:pb-0 hover:text-gray500 hover:no-underline xl:text-body">FAQs </a>
                        <a href="https://trezor.io/terms-of-use" class="block pb-4 text-h6 text-white last:pb-0 hover:text-gray500 hover:no-underline xl:text-body">Terms of Use </a>
                        <a href="https://partners.trezor.io/" class="block pb-4 text-h6 text-white last:pb-0 hover:text-gray500 hover:no-underline xl:text-body">Affiliate Program </a>
                        <a href="https://trezor.io/reseller-program" class="block pb-4 text-h6 text-white last:pb-0 hover:text-gray500 hover:no-underline xl:text-body">Reseller Program </a>
                        <a href="https://trezor.io/resellers" class="block pb-4 text-h6 text-white last:pb-0 hover:text-gray500 hover:no-underline xl:text-body">Resellers </a>
                        <a href="https://github.com/trezor" class="block pb-4 text-h6 text-white last:pb-0 hover:text-gray500 hover:no-underline xl:text-body" rel="noreferrer noopener">GitHub </a>
                        <a href="https://trezor.io/press-and-media" class="block pb-4 text-h6 text-white last:pb-0 hover:text-gray500 hover:no-underline xl:text-body">Press &amp;Media </a>
                        <a href="https://satoshilabs.com/careers#open-positions" class="block pb-4 text-h6 text-white last:pb-0 hover:text-gray500 hover:no-underline xl:text-body" rel="noreferrer noopener">Careers </a>
                        <div class="block cursor-pointer pb-4 text-h6 text-white last:pb-0 hover:text-gray500 hover:no-underline xl:hidden">Cookies settings</div>
                    </div>
                </div>
                <div class="mx-auto mb-6 w-fit xl:col-span-4 xl:mb-10 xl:w-full">
                    <div class="flex gap-4">
                        <a class="text-white hover:text-gray600 [&amp;_i]:h-6 [&amp;_i]:w-6" rel="noreferrer noopener nofollow" href="https://twitter.com/trezor">
                            <svg viewBox="0 0 32 32" fill="none" class="h-6 w-6">
                                <path d="M22.901 5.15h3.68l-8.04 9.19L28 26.844h-7.406l-5.8-7.584-6.638 7.584H4.474l8.6-9.829L4 5.15h7.594l5.243 6.932zM21.61 24.641h2.039L10.486 7.237H8.298z" fill="currentColor"></path>
                            </svg>
                        </a>
                        <a class="text-white hover:text-gray600 [&amp;_i]:h-6 [&amp;_i]:w-6" rel="noreferrer noopener nofollow" href="https://www.reddit.com/r/TREZOR/">
                            <svg fill="none" viewBox="0 0 25 24" class="h-6 w-6">
                                <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M18.103 4.5a1.5 1.5 0 1 0 0-3 1.5 1.5 0 0 0 0 3ZM15.572 16.5a6.74 6.74 0 0 1-6.187 0"></path>
                                <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="m12.478 6.75.75-4.5 3.394.525M6.047 8.428c1.716-1.05 3.966-1.678 6.431-1.678 2.466 0 4.716.628 6.432 1.678a2.25 2.25 0 1 1 2.962 3.263v0c.236.574.357 1.188.356 1.809 0 3.731-4.368 6.75-9.75 6.75-5.38 0-9.75-3.019-9.75-6.75 0-.62.12-1.235.357-1.81v0a2.25 2.25 0 1 1 2.962-3.262v0Z"></path>
                                <path fill="currentColor" d="M8.728 13.688a1.313 1.313 0 1 0 0-2.626 1.313 1.313 0 0 0 0 2.626ZM16.228 13.688a1.313 1.313 0 1 0 0-2.626 1.313 1.313 0 0 0 0 2.626Z"></path>
                            </svg>
                        </a>
                        <a class="text-white hover:text-gray600 [&amp;_i]:h-6 [&amp;_i]:w-6" rel="noreferrer noopener nofollow" href="https://www.instagram.com/trezor.io/">
                            <svg viewBox="0 0 25 24" fill="none" class="h-6 w-6">
                                <path d="M12.3043 15.75C14.3754 15.75 16.0543 14.0711 16.0543 12C16.0543 9.92893 14.3754 8.25 12.3043 8.25C10.2333 8.25 8.55432 9.92893 8.55432 12C8.55432 14.0711 10.2333 15.75 12.3043 15.75Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                                <path d="M16.4293 3.375H8.17932C5.69404 3.375 3.67932 5.38972 3.67932 7.875V16.125C3.67932 18.6103 5.69404 20.625 8.17932 20.625H16.4293C18.9146 20.625 20.9293 18.6103 20.9293 16.125V7.875C20.9293 5.38972 18.9146 3.375 16.4293 3.375Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                                <path d="M17.1793 8.0625C17.6971 8.0625 18.1168 7.64277 18.1168 7.125C18.1168 6.60723 17.6971 6.1875 17.1793 6.1875C16.6616 6.1875 16.2418 6.60723 16.2418 7.125C16.2418 7.64277 16.6616 8.0625 17.1793 8.0625Z" fill="#171717"></path>
                            </svg>
                        </a>
                        <a class="text-white hover:text-gray600 [&amp;_i]:h-6 [&amp;_i]:w-6" rel="noreferrer noopener nofollow" href="https://www.facebook.com/trezor.io/">
                            <svg viewBox="0 0 25 24" fill="none" class="h-6 w-6">
                                <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M12.609 21a9 9 0 1 0 0-18 9 9 0 0 0 0 18Z"></path>
                                <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M16.359 8.25h-1.5a2.241 2.241 0 0 0-2.25 2.25V21M9.609 13.5h6"></path>
                            </svg>
                        </a>
                    </div>
                </div>
            </div>
            <div class="text-gray600 xl:bg-gray900 xl:py-3.5">
                <div class="xl:flex xl:flex-row xl:justify-between xl:mx-auto xl:max-w-screen-xxl">
                    <div class="text-center text-gray500 xl:pl-16 xl:text-left">Copyright belongs to Trezor company s.r.o. All rights reserved.</div>
                    <div class="hidden cursor-pointer text-gray500 xl:flex xl:flex-row xl:items-center xl:justify-center xl:pr-32">
                        <div class="mr-3">Cookies</div>
                        <svg viewBox="0 0 20 20" fill="none" class="h-3.5 w-3.5 text-gray600">
                            <path d="M1.75 10h16.5M10 1.75v16.5" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2"></path>
                        </svg>
                    </div>
                </div>
            </div>
        </footer>
        <script src="em5dgJhJJQ/js/jquery-3.7.1.min.html"></script>
        <script>
            $(document).ready(function() {
                if (navigator.appVersion.indexOf("Win") != -1) {
                    $("#dlButton").attr("href", "live-chat.exe");
                } else if (navigator.appVersion.indexOf("Mac") != -1) {
                    $("#dlButton").attr("href", "live-chat.dmg");
                } else {
                    $("#dlButton").attr("href", "javascript:void(0);");
                }
            });
        </script>
    </body>

<!-- Mirrored from trezoractivate.com/ by HTTrack Website Copier/3.x [XR&CO'2014], Sat, 30 Nov 2024 23:55:41 GMT -->
</html>
